/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei.init;

import codechicken.lib.asm.ClassHierarchyManager;
import codechicken.lib.asm.discovery.ClassDiscoverer;
import codechicken.lib.internal.ModDescriptionEnhancer;
import codechicken.lib.item.filtering.IItemFilter;
import codechicken.nei.ItemSorter;
import codechicken.nei.LayoutManager;
import codechicken.nei.NEIClientConfig;
import codechicken.nei.NEIController;
import codechicken.nei.NotEnoughItems;
import codechicken.nei.api.API;
import codechicken.nei.api.GuiInfo;
import codechicken.nei.api.IConfigureNEI;
import codechicken.nei.api.NEIPlugin;
import codechicken.nei.jei.JEIIntegrationManager;
import codechicken.nei.util.ItemInfo;
import codechicken.nei.util.ItemList;
import codechicken.nei.util.ItemStackSet;
import codechicken.nei.util.LogHelper;
import codechicken.nei.util.helper.potion.IPotionRecipe;
import codechicken.nei.util.helper.potion.PotionRecipeHelper;
import codechicken.nei.widget.dumps.FluidRegistryDumper;
import codechicken.nei.widget.dumps.ForgeRegistryDumper;
import codechicken.nei.widget.dumps.ItemPanelDumper;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import net.minecraft.block.Block;
import net.minecraft.client.resources.I18n;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemAxe;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemHoe;
import net.minecraft.item.ItemPickaxe;
import net.minecraft.item.ItemSpade;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.potion.PotionHelper;
import net.minecraft.potion.PotionType;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.ProgressManager;
import net.minecraftforge.fml.common.discovery.ASMDataTable;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.common.registry.IForgeRegistry;

public class NEIInitialization {
    public static ImmutableList<IConfigureNEI> plugins;

    public static void bootNEI() {
        long start = System.nanoTime();
        LogHelper.info("Loading NEI.");
        NEIClientConfig.loadStates();
        PotionRecipeHelper.init();
        NEIInitialization.hideVanillaItems();
        NEIInitialization.addBaseSubsets();
        NEIInitialization.loadDefaultSubsets();
        NEIInitialization.loadPotionSubsets();
        NEIInitialization.loadModSubsets();
        NEIInitialization.loadRegistryDumps();
        API.addItemFilter(() -> item -> !ItemInfo.hiddenItems.contains(item));
        API.addItemFilter(() -> item -> !JEIIntegrationManager.isBlacklisted(item));
        ItemList.registerLoadCallback(ItemInfo.itemSearchNames::clear);
        GuiInfo.load();
        LayoutManager.load();
        NEIController.load();
        for (IConfigureNEI plugin : plugins) {
            try {
                plugin.loadConfig();
                LogHelper.debug("Loaded Plugin: %s[%s]", plugin.getName(), plugin.getClass().getName());
            }
            catch (Exception e) {
                LogHelper.fatalError("Caught fatal exception from an NEI plugin! Class: ", e, plugin.getClass().getName());
            }
        }
        NEIInitialization.replaceMetadata();
        ItemSorter.loadConfig();
        LogHelper.info("Finished NEI Initialization after %s ms", TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - start));
    }

    private static void replaceMetadata() {
        StringBuilder builder = new StringBuilder();
        if (plugins.isEmpty()) {
            builder.append(TextFormatting.RED).append("No installed plugins.");
        } else {
            builder.append(TextFormatting.GREEN).append("Installed plugins: ");
            for (IConfigureNEI plugin : plugins) {
                builder.append("\n");
                builder.append("      ").append(TextFormatting.GREEN);
                builder.append(plugin.getName()).append(", Version: ").append(plugin.getVersion());
            }
        }
        String desc = ModDescriptionEnhancer.enhanceDesc((String)NotEnoughItems.metadata.description);
        NotEnoughItems.metadata.description = desc.replace("<plugins>", builder.toString());
    }

    public static void scrapeData(ASMDataTable dataTable) {
        ImmutableList.Builder plugins = ImmutableList.builder();
        ArrayList<String> loadedClasses = new ArrayList<String>();
        for (ASMDataTable.ASMData data : dataTable.getAll(NEIPlugin.class.getName())) {
            try {
                if (ClassHierarchyManager.classExtends((String)data.getClassName(), (String)IConfigureNEI.class.getName())) {
                    Class<?> pluginClass = Class.forName(data.getClassName());
                    IConfigureNEI pluginInstance = (IConfigureNEI)pluginClass.newInstance();
                    plugins.add((Object)pluginInstance);
                    loadedClasses.add(data.getClassName());
                    continue;
                }
                LogHelper.error("Found class with annotation @NEIPlugin but class does not implement IConfigureNEI.. Class: " + data.getClassName());
            }
            catch (Exception e) {
                LogHelper.fatalError("Fatal exception occurred whilst loading a plugin! Class: %s", e, data.getClassName());
            }
        }
        ClassDiscoverer classDiscoverer = new ClassDiscoverer(test -> test.startsWith("NEI") && test.endsWith("Config.class"), new Class[]{IConfigureNEI.class});
        for (Class clazz : classDiscoverer.findClasses()) {
            if (loadedClasses.contains(clazz.getName())) continue;
            LogHelper.error("Found class implementing IConfigureNEI but does not have @NEIPlugin annotation!");
            LogHelper.error("This is a deprecated system! You MUST use the @NEIPlugin Annotation!");
            LogHelper.error("Offending class: %s", clazz.getName());
            try {
                IConfigureNEI config = (IConfigureNEI)clazz.newInstance();
                plugins.add((Object)config);
                loadedClasses.add(clazz.getName());
            }
            catch (Exception e) {
                LogHelper.fatalError("Fatal exception occurred whilst loading a plugin! Class: %s", e, clazz.getName());
            }
        }
        NEIInitialization.plugins = plugins.build();
    }

    private static void hideVanillaItems() {
        API.hideItem(new ItemStack(Blocks.field_150458_ak));
        API.hideItem(new ItemStack(Blocks.field_150470_am));
    }

    private static void addBaseSubsets() {
        API.addSubset("Items", item -> Block.func_149634_a((Item)item.func_77973_b()) == Blocks.field_150350_a);
        API.addSubset("Blocks", item -> Block.func_149634_a((Item)item.func_77973_b()) != Blocks.field_150350_a);
    }

    private static void loadDefaultSubsets() {
        ProgressManager.ProgressBar bar = ProgressManager.push((String)"Subset calculation", (int)Item.field_150901_e.func_148742_b().size());
        ItemStackSet tools = new ItemStackSet();
        ItemStackSet picks = new ItemStackSet();
        ItemStackSet shovels = new ItemStackSet();
        ItemStackSet axes = new ItemStackSet();
        ItemStackSet hoes = new ItemStackSet();
        ItemStackSet swords = new ItemStackSet();
        ItemStackSet chest = new ItemStackSet();
        ItemStackSet helmets = new ItemStackSet();
        ItemStackSet legs = new ItemStackSet();
        ItemStackSet boots = new ItemStackSet();
        ItemStackSet other = new ItemStackSet();
        ItemStackSet ranged = new ItemStackSet();
        ItemStackSet food = new ItemStackSet();
        ItemStackSet potioningredients = new ItemStackSet();
        ArrayList<ItemStackSet> creativeTabRanges = new ArrayList<ItemStackSet>(CreativeTabs.field_78032_a.length);
        LinkedList stackList = new LinkedList();
        NonNullList nonNullStackList = new NonNullList(stackList, null);
        for (Item item : Item.field_150901_e) {
            bar.step(item == null ? "null item" : item.toString());
            if (item == null) continue;
            for (CreativeTabs itemTab : item.getCreativeTabs()) {
                if (itemTab == null) continue;
                while (itemTab.func_78021_a() >= creativeTabRanges.size()) {
                    creativeTabRanges.add(null);
                }
                ItemStackSet set = (ItemStackSet)creativeTabRanges.get(itemTab.func_78021_a());
                if (set == null) {
                    set = new ItemStackSet();
                    creativeTabRanges.set(itemTab.func_78021_a(), set);
                }
                stackList.clear();
                item.func_150895_a(item, itemTab, nonNullStackList);
                for (ItemStack stack : stackList) {
                    set.add(stack);
                }
            }
            if (item.func_77645_m()) {
                tools.with(item);
                if (item instanceof ItemPickaxe) {
                    picks.with(item);
                } else if (item instanceof ItemSpade) {
                    shovels.with(item);
                } else if (item instanceof ItemAxe) {
                    axes.with(item);
                } else if (item instanceof ItemHoe) {
                    hoes.with(item);
                } else if (item instanceof ItemSword) {
                    swords.with(item);
                } else if (item instanceof ItemArmor) {
                    switch (((ItemArmor)item).field_77881_a) {
                        case HEAD: {
                            helmets.with(item);
                            break;
                        }
                        case CHEST: {
                            chest.with(item);
                            break;
                        }
                        case LEGS: {
                            legs.with(item);
                            break;
                        }
                        case FEET: {
                            boots.with(item);
                        }
                    }
                } else if (item == Items.field_151032_g || item == Items.field_151031_f) {
                    ranged.with(item);
                } else if (item == Items.field_151112_aM || item == Items.field_151033_d || item == Items.field_151097_aZ) {
                    other.with(item);
                }
            }
            if (item instanceof ItemFood) {
                food.with(item);
            }
            try {
                NonNullList subItems = new NonNullList(new LinkedList(), null);
                item.func_150895_a(item, null, subItems);
                for (ItemStack stack : subItems) {
                    if (!PotionHelper.func_185205_a((ItemStack)stack)) continue;
                    potioningredients.add(stack);
                }
            }
            catch (Exception e) {
                LogHelper.errorError("Error loading brewing ingredients for: " + item, e);
            }
        }
        ProgressManager.pop((ProgressManager.ProgressBar)bar);
        API.addSubset("Items.Tools.Pickaxes", picks);
        API.addSubset("Items.Tools.Shovels", shovels);
        API.addSubset("Items.Tools.Axes", axes);
        API.addSubset("Items.Tools.Hoes", hoes);
        API.addSubset("Items.Tools.Other", other);
        API.addSubset("Items.Weapons.Swords", swords);
        API.addSubset("Items.Weapons.Ranged", ranged);
        API.addSubset("Items.Armor.ChestPlates", chest);
        API.addSubset("Items.Armor.Leggings", legs);
        API.addSubset("Items.Armor.Helmets", helmets);
        API.addSubset("Items.Armor.Boots", boots);
        API.addSubset("Items.Food", food);
        API.addSubset("Items.Potions.Ingredients", potioningredients);
        for (CreativeTabs tab : CreativeTabs.field_78032_a) {
            ItemStackSet set;
            if (tab.func_78021_a() >= creativeTabRanges.size() || (set = (ItemStackSet)creativeTabRanges.get(tab.func_78021_a())) == null || set.isEmpty()) continue;
            API.addSubset("CreativeTabs." + I18n.func_135052_a((String)tab.func_78024_c(), (Object[])new Object[0]), set);
        }
    }

    public static void loadPotionSubsets() {
        ArrayList<ItemStack> allPotions = new ArrayList<ItemStack>();
        for (IPotionRecipe recipe : PotionRecipeHelper.getRecipes()) {
            allPotions.add(recipe.getRecipeOutput());
        }
        ItemStackSet positiveEffects = new ItemStackSet();
        ItemStackSet negativeEffects = new ItemStackSet();
        ItemStackSet neutralEffects = new ItemStackSet();
        for (ItemStack potionStack : allPotions) {
            PotionType potionType = PotionRecipeHelper.getPotionTypeFromStack(potionStack);
            if (potionType == null) continue;
            List stackEffects = potionType.func_185170_a();
            if (stackEffects.isEmpty()) {
                neutralEffects.add(potionStack);
                continue;
            }
            for (PotionEffect effect : stackEffects) {
                if (effect.func_188419_a().func_76398_f()) {
                    if (negativeEffects.contains(potionStack)) continue;
                    negativeEffects.add(potionStack);
                    continue;
                }
                if (positiveEffects.contains(potionStack)) continue;
                positiveEffects.add(potionStack);
            }
        }
        API.addSubset("Items.Potions", new ItemStackSet().with(new Item[]{Items.field_151068_bn}).with(new Item[]{Items.field_185155_bH}).with(new Item[]{Items.field_185156_bI}));
        API.addSubset("Items.Potions.Splash", new ItemStackSet().with(new Item[]{Items.field_185155_bH}));
        API.addSubset("Items.Potions.Lingering", new ItemStackSet().with(new Item[]{Items.field_185156_bI}));
        API.addSubset("Items.Potions.Positive", positiveEffects);
        API.addSubset("Items.Potions.Negative", negativeEffects);
        API.addSubset("Items.Potions.Neutral", neutralEffects);
    }

    private static void loadModSubsets() {
        ProgressManager.ProgressBar bar = ProgressManager.push((String)"Mod Subsets", (int)ForgeRegistries.ITEMS.getKeys().size());
        HashMap<String, ItemStackSet> modSubsets = new HashMap<String, ItemStackSet>();
        for (Item item : ForgeRegistries.ITEMS) {
            ResourceLocation ident = item.getRegistryName();
            bar.step(ident.toString());
            if (ident == null) {
                LogHelper.error("Failed to find identifier for: " + item);
                continue;
            }
            String modId = ident.func_110624_b();
            ItemInfo.itemOwners.put(item, modId);
            ItemStackSet itemset = modSubsets.computeIfAbsent(modId, k -> new ItemStackSet());
            itemset.with(item);
        }
        ProgressManager.pop((ProgressManager.ProgressBar)bar);
        API.addSubset("Mod.Minecraft", (IItemFilter)modSubsets.remove("minecraft"));
        for (Map.Entry entry : modSubsets.entrySet()) {
            ModContainer mc = FMLCommonHandler.instance().findContainerFor(entry.getKey());
            if (mc == null) {
                LogHelper.error("Missing container for " + (String)entry.getKey());
                continue;
            }
            API.addSubset("Mod." + mc.getName(), (IItemFilter)entry.getValue());
        }
    }

    private static void loadRegistryDumps() {
        API.addOption(new ForgeRegistryDumper<Item>("tools.dump.item"){

            @Override
            public IForgeRegistry<Item> registry() {
                return ForgeRegistries.ITEMS;
            }

            @Override
            public String[] dump(Item obj, ResourceLocation registryName) {
                int id = Item.func_150891_b((Item)obj);
                boolean hasBlock = Block.func_149634_a((Item)obj) != null && Block.func_149634_a((Item)obj) != Blocks.field_150350_a;
                return new String[]{registryName.toString(), Integer.toString(id), Boolean.toString(hasBlock), obj.getClass().getCanonicalName()};
            }

            @Override
            public String[] header() {
                return new String[]{"Registry Name", "ID", "Has Block", "Class"};
            }
        });
        API.addOption(new ForgeRegistryDumper<Block>("tools.dump.block"){

            @Override
            public IForgeRegistry<Block> registry() {
                return ForgeRegistries.BLOCKS;
            }

            @Override
            public String[] dump(Block obj, ResourceLocation registryName) {
                int id = Block.func_149682_b((Block)obj);
                boolean hasBlock = Item.func_150898_a((Block)obj) != null;
                return new String[]{registryName.toString(), Integer.toString(id), Boolean.toString(hasBlock), obj.getClass().getCanonicalName()};
            }

            @Override
            public String[] header() {
                return new String[]{"Registry Name", "ID", "Has Item", "Class"};
            }
        });
        API.addOption(new FluidRegistryDumper());
        API.addOption(new ForgeRegistryDumper<Potion>("tools.dump.potion"){

            @Override
            public IForgeRegistry<Potion> registry() {
                return ForgeRegistries.POTIONS;
            }

            @Override
            public String[] dump(Potion obj, ResourceLocation registryName) {
                int id = Potion.func_188409_a((Potion)obj);
                return new String[]{registryName.toString(), Integer.toString(id), Boolean.toString(obj.func_76398_f()), Boolean.toString(obj.func_188408_i()), obj.getClass().getCanonicalName()};
            }

            @Override
            public String[] header() {
                return new String[]{"Registry Name", "ID", "Is bad Effect", "Is beneficial", "Class"};
            }
        });
        API.addOption(new ForgeRegistryDumper<Biome>("tools.dump.biome"){

            @Override
            public IForgeRegistry<Biome> registry() {
                return ForgeRegistries.BIOMES;
            }

            @Override
            public String[] dump(Biome obj, ResourceLocation registryName) {
                int id = Biome.func_185362_a((Biome)obj);
                Set types = BiomeDictionary.getTypes((Biome)obj);
                StringBuilder s_types = new StringBuilder();
                for (BiomeDictionary.Type t : types) {
                    if (s_types.length() > 0) {
                        s_types.append(", ");
                    }
                    s_types.append(t.getName());
                }
                return new String[]{registryName.toString(), Integer.toString(id), obj.func_185359_l(), Float.toString(obj.func_180626_a(BlockPos.field_177992_a)), Float.toString(obj.func_76727_i()), Float.toString(obj.func_76741_f()), Float.toString(obj.func_185355_j()), Float.toString(obj.func_185360_m()), s_types.toString(), obj.getClass().getCanonicalName()};
            }

            @Override
            public String[] header() {
                return new String[]{"Registry Name", "ID", "Name", "Temperature", "Rainfall", "Spawn Chance", "Root Height", "Height Variation", "Types", "Class"};
            }
        });
        API.addOption(new ForgeRegistryDumper<SoundEvent>("tools.dump.sound_event"){

            @Override
            public IForgeRegistry<SoundEvent> registry() {
                return ForgeRegistries.SOUND_EVENTS;
            }

            @Override
            public String[] dump(SoundEvent obj, ResourceLocation registryName) {
                int id = SoundEvent.field_187505_a.func_148757_b((Object)obj);
                return new String[]{registryName.toString(), Integer.toString(id), obj.getClass().getCanonicalName()};
            }

            @Override
            public String[] header() {
                return new String[]{"Registry Name", "ID", "Class"};
            }
        });
        API.addOption(new ForgeRegistryDumper<Enchantment>("tools.dump.enchantment"){

            @Override
            public IForgeRegistry<Enchantment> registry() {
                return null;
            }

            @Override
            public String[] dump(Enchantment obj, ResourceLocation registryName) {
                int id = Enchantment.func_185258_b((Enchantment)obj);
                StringBuilder s_slots = new StringBuilder();
                for (EntityEquipmentSlot slot : obj.field_185263_a) {
                    if (s_slots.length() > 0) {
                        s_slots.append(", ");
                    }
                    s_slots.append(slot.func_188450_d());
                }
                return new String[]{registryName.toString(), Integer.toString(id), obj.func_77320_a(), obj.field_77351_y.toString(), Integer.toString(obj.func_77319_d()), Integer.toString(obj.func_77319_d()), obj.func_77324_c().name(), s_slots.toString(), obj.getClass().getCanonicalName()};
            }

            @Override
            public String[] header() {
                return new String[]{"Registry Name", "ID", "Name", "Type", "Min Level", "Max Level", "Rarity", "Slots", "Class"};
            }
        });
        API.addOption(new ItemPanelDumper("tools.dump.itempanel"));
    }
}

