/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei;

import codechicken.core.ClientUtils;
import codechicken.lib.inventory.InventoryUtils;
import codechicken.lib.packet.PacketCustom;
import codechicken.nei.ClientHandler;
import codechicken.nei.ContainerCreativeInv;
import codechicken.nei.ExtendedCreativeInv;
import codechicken.nei.GuiEnchantmentModifier;
import codechicken.nei.GuiExtendedCreativeInv;
import codechicken.nei.GuiPotionCreator;
import codechicken.nei.LayoutManager;
import codechicken.nei.NEIClientConfig;
import codechicken.nei.NEIClientUtils;
import codechicken.nei.NEIServerUtils;
import cpw.mods.fml.relauncher.Side;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiInventory;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.play.INetHandlerPlayClient;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;

public class NEICPH
implements PacketCustom.IClientPacketHandler {
    public static final String channel = "NEI";

    public void handlePacket(PacketCustom packet, Minecraft mc, INetHandlerPlayClient netHandler) {
        switch (packet.getType()) {
            case 1: {
                this.handleSMPCheck(packet.readUByte(), packet.readString(), (World)mc.field_71441_e);
                break;
            }
            case 10: {
                this.handleLoginState(packet);
                break;
            }
            case 11: {
                this.handleActionDisabled(packet);
                break;
            }
            case 12: {
                this.handleActionEnabled(packet);
                break;
            }
            case 13: {
                ClientHandler.instance().addSMPMagneticItem(packet.readInt(), (World)mc.field_71441_e);
                break;
            }
            case 14: {
                this.handleGamemode(mc, packet.readUByte());
                break;
            }
            case 21: {
                ClientUtils.openSMPGui((int)packet.readUByte(), (GuiScreen)new GuiEnchantmentModifier(mc.field_71439_g.field_71071_by, (World)mc.field_71441_e, 0, 0, 0));
                break;
            }
            case 23: {
                if (packet.readBoolean()) {
                    ClientUtils.openSMPGui((int)packet.readUByte(), (GuiScreen)new GuiExtendedCreativeInv(new ContainerCreativeInv((EntityPlayer)mc.field_71439_g, new ExtendedCreativeInv(null, Side.CLIENT))));
                    break;
                }
                mc.func_147108_a((GuiScreen)new GuiInventory((EntityPlayer)mc.field_71439_g));
                break;
            }
            case 24: {
                ClientUtils.openSMPGui((int)packet.readUByte(), (GuiScreen)new GuiPotionCreator(mc.field_71439_g.field_71071_by));
            }
        }
    }

    private void handleGamemode(Minecraft mc, int mode) {
        mc.field_71442_b.func_78746_a(NEIServerUtils.getGameType(mode));
    }

    private void handleActionEnabled(PacketCustom packet) {
        String name = packet.readString();
        if (packet.readBoolean()) {
            NEIClientConfig.enabledActions.add(name);
        } else {
            NEIClientConfig.enabledActions.remove(name);
        }
    }

    private void handleActionDisabled(PacketCustom packet) {
        String name = packet.readString();
        if (packet.readBoolean()) {
            NEIClientConfig.disabledActions.add(name);
        } else {
            NEIClientConfig.disabledActions.remove(name);
        }
    }

    private void handleLoginState(PacketCustom packet) {
        int i;
        NEIClientConfig.permissableActions.clear();
        int num = packet.readUByte();
        for (i = 0; i < num; ++i) {
            NEIClientConfig.permissableActions.add(packet.readString());
        }
        NEIClientConfig.disabledActions.clear();
        num = packet.readUByte();
        for (i = 0; i < num; ++i) {
            NEIClientConfig.disabledActions.add(packet.readString());
        }
        NEIClientConfig.enabledActions.clear();
        num = packet.readUByte();
        for (i = 0; i < num; ++i) {
            NEIClientConfig.enabledActions.add(packet.readString());
        }
        NEIClientConfig.bannedBlocks.clear();
        num = packet.readInt();
        for (i = 0; i < num; ++i) {
            NEIClientConfig.bannedBlocks.add(packet.readItemStack());
        }
        if (NEIClientUtils.getGuiContainer() != null) {
            LayoutManager.instance().refresh(NEIClientUtils.getGuiContainer());
        }
    }

    private void handleSMPCheck(int serverprotocol, String worldName, World world) {
        if (serverprotocol > 0) {
            NEIClientUtils.printChatMessage((IChatComponent)new ChatComponentTranslation("nei.chat.mismatch.client", new Object[0]));
        } else if (serverprotocol < 0) {
            NEIClientUtils.printChatMessage((IChatComponent)new ChatComponentTranslation("nei.chat.mismatch.server", new Object[0]));
        } else {
            try {
                ClientHandler.instance().loadWorld(world, true);
                NEIClientConfig.loadWorld(NEICPH.getSaveName(worldName));
                NEIClientConfig.setHasSMPCounterPart(true);
                NEICPH.sendRequestLoginInfo();
            }
            catch (Exception nce) {
                nce.printStackTrace();
            }
        }
    }

    private static String getSaveName(String worldName) {
        if (Minecraft.func_71410_x().func_71356_B()) {
            return "local/" + ClientUtils.getWorldSaveName();
        }
        return "remote/" + ClientUtils.getServerIP().replace(':', '~') + "/" + worldName;
    }

    public static void sendGiveItem(ItemStack spawnstack, boolean infinite, boolean doSpawn) {
        PacketCustom packet = new PacketCustom((Object)channel, 1);
        packet.writeItemStack(spawnstack, true);
        packet.writeBoolean(infinite);
        packet.writeBoolean(doSpawn);
        packet.sendToServer();
    }

    public static void sendDeleteAllItems() {
        PacketCustom packet = new PacketCustom((Object)channel, 4);
        packet.sendToServer();
    }

    public static void sendStateLoad(ItemStack[] state) {
        NEICPH.sendDeleteAllItems();
        for (int slot = 0; slot < state.length; ++slot) {
            ItemStack item = state[slot];
            if (item == null) continue;
            NEICPH.sendSetSlot(slot, item, false);
        }
        PacketCustom packet = new PacketCustom((Object)channel, 11);
        packet.sendToServer();
    }

    public static void sendSetSlot(int slot, ItemStack stack, boolean container) {
        PacketCustom packet = new PacketCustom((Object)channel, 5);
        packet.writeBoolean(container);
        packet.writeShort(slot);
        packet.writeItemStack(stack);
        packet.sendToServer();
    }

    private static void sendRequestLoginInfo() {
        PacketCustom packet = new PacketCustom((Object)channel, 10);
        packet.sendToServer();
    }

    public static void sendToggleMagnetMode() {
        PacketCustom packet = new PacketCustom((Object)channel, 6);
        packet.sendToServer();
    }

    public static void sendSetTime(int hour) {
        PacketCustom packet = new PacketCustom((Object)channel, 7);
        packet.writeByte(hour);
        packet.sendToServer();
    }

    public static void sendHeal() {
        PacketCustom packet = new PacketCustom((Object)channel, 8);
        packet.sendToServer();
    }

    public static void sendToggleRain() {
        PacketCustom packet = new PacketCustom((Object)channel, 9);
        packet.sendToServer();
    }

    public static void sendOpenEnchantmentWindow() {
        PacketCustom packet = new PacketCustom((Object)channel, 21);
        packet.sendToServer();
    }

    public static void sendModifyEnchantment(int enchID, int level, boolean add) {
        PacketCustom packet = new PacketCustom((Object)channel, 22);
        packet.writeByte(enchID);
        packet.writeByte(level);
        packet.writeBoolean(add);
        packet.sendToServer();
    }

    public static void sendSetPropertyDisabled(String name, boolean enable) {
        PacketCustom packet = new PacketCustom((Object)channel, 12);
        packet.writeString(name);
        packet.writeBoolean(enable);
        packet.sendToServer();
    }

    public static void sendGamemode(int mode) {
        new PacketCustom((Object)channel, 13).writeByte(mode).sendToServer();
    }

    public static void sendCreativeInv(boolean open) {
        PacketCustom packet = new PacketCustom((Object)channel, 23);
        packet.writeBoolean(open);
        packet.sendToServer();
    }

    public static void sendCreativeScroll(int steps) {
        PacketCustom packet = new PacketCustom((Object)channel, 14);
        packet.writeInt(steps);
        packet.sendToServer();
    }

    public static void sendMobSpawnerID(int x, int y, int z, String mobtype) {
        PacketCustom packet = new PacketCustom((Object)channel, 15);
        packet.writeCoord(x, y, z);
        packet.writeString(mobtype);
        packet.sendToServer();
    }

    public static PacketCustom createContainerPacket() {
        return new PacketCustom((Object)channel, 20);
    }

    public static void sendOpenPotionWindow() {
        ItemStack[] potionStore = new ItemStack[9];
        InventoryUtils.readItemStacksFromTag((ItemStack[])potionStore, (NBTTagList)NEIClientConfig.global.nbt.func_74775_l("potionStore").func_150295_c("items", 10));
        PacketCustom packet = new PacketCustom((Object)channel, 24);
        for (ItemStack stack : potionStore) {
            packet.writeItemStack(stack);
        }
        packet.sendToServer();
    }

    public static void sendDummySlotSet(int slotNumber, ItemStack stack) {
        PacketCustom packet = new PacketCustom((Object)channel, 25);
        packet.writeShort(slotNumber);
        packet.writeItemStack(stack, true);
        packet.sendToServer();
    }
}

