/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei.network;

import codechicken.core.IGuiPacketSender;
import codechicken.core.ServerUtils;
import codechicken.core.inventory.ContainerExtended;
import codechicken.core.inventory.SlotDummy;
import codechicken.lib.packet.PacketCustom;
import codechicken.lib.vec.BlockCoord;
import codechicken.nei.ContainerEnchantmentModifier;
import codechicken.nei.ContainerPotionCreator;
import codechicken.nei.ItemStackMap;
import codechicken.nei.NEIActions;
import codechicken.nei.NEIServerConfig;
import codechicken.nei.PlayerSave;
import codechicken.nei.container.ContainerCreativeInv;
import codechicken.nei.container.ExtendedCreativeInv;
import codechicken.nei.util.LogHelper;
import codechicken.nei.util.NEIServerUtils;
import java.util.LinkedList;
import java.util.Set;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.network.play.INetHandlerPlayServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityMobSpawner;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;

public class NEIServerPacketHandler
implements PacketCustom.IServerPacketHandler {
    public static final String channel = "NEI";

    public void handlePacket(PacketCustom packet, EntityPlayerMP sender, INetHandlerPlayServer netHandler) {
        if (!NEIServerConfig.authenticatePacket(sender, packet)) {
            return;
        }
        switch (packet.getType()) {
            case 1: {
                this.handleGiveItem(sender, packet);
                break;
            }
            case 4: {
                NEIServerUtils.deleteAllItems(sender);
                break;
            }
            case 5: {
                this.setInventorySlot(sender, packet);
                break;
            }
            case 6: {
                NEIServerUtils.toggleMagnetMode(sender);
                break;
            }
            case 7: {
                NEIServerUtils.setHourForward(sender.field_70170_p, packet.readUByte(), true);
                break;
            }
            case 8: {
                NEIServerUtils.healPlayer((EntityPlayer)sender);
                break;
            }
            case 9: {
                NEIServerUtils.toggleRaining(sender.field_70170_p, true);
                break;
            }
            case 10: {
                this.sendLoginState(sender);
                break;
            }
            case 11: {
                sender.func_71110_a(sender.field_71070_bA, sender.field_71070_bA.func_75138_a());
                break;
            }
            case 12: {
                this.handlePropertyChange(sender, packet);
                break;
            }
            case 13: {
                NEIServerUtils.setGamemode(sender, packet.readUByte());
                break;
            }
            case 14: {
                NEIServerUtils.cycleCreativeInv(sender, packet.readInt());
                break;
            }
            case 15: {
                this.handleMobSpawnerID(sender.field_70170_p, packet.readCoord(), packet.readString());
                break;
            }
            case 20: {
                this.handleContainerPacket(sender, packet);
                break;
            }
            case 21: {
                this.openEnchantmentGui(sender);
                break;
            }
            case 22: {
                this.modifyEnchantment(sender, packet.readUByte(), packet.readUByte(), packet.readBoolean());
                break;
            }
            case 23: {
                NEIServerPacketHandler.processCreativeInv(sender, packet.readBoolean());
                break;
            }
            case 24: {
                this.openPotionGui(sender, packet);
                break;
            }
            case 25: {
                this.handleDummySlotSet(sender, packet);
            }
        }
    }

    private void handleDummySlotSet(EntityPlayerMP sender, PacketCustom packet) {
        Slot slot = sender.field_71070_bA.func_75139_a((int)packet.readShort());
        if (slot instanceof SlotDummy) {
            slot.func_75215_d(packet.readItemStack());
        }
    }

    private void handleContainerPacket(EntityPlayerMP sender, PacketCustom packet) {
        if (sender.field_71070_bA instanceof ContainerExtended) {
            ((ContainerExtended)sender.field_71070_bA).handleInputPacket(packet);
        }
    }

    private void handleMobSpawnerID(World world, BlockCoord coord, String mobtype) {
        TileEntity tile = world.func_175625_s(coord.pos());
        if (tile instanceof TileEntityMobSpawner) {
            ((TileEntityMobSpawner)tile).func_145881_a().func_98272_a(mobtype);
            tile.func_70296_d();
            IBlockState state = world.func_180495_p(coord.pos());
            world.func_184138_a(coord.pos(), state, state, 4);
        }
    }

    private void handlePropertyChange(EntityPlayerMP sender, PacketCustom packet) {
        String name = packet.readString();
        if (NEIServerConfig.canPlayerPerformAction(sender.func_70005_c_(), name)) {
            NEIServerConfig.disableAction(sender.field_71093_bK, name, packet.readBoolean());
        }
    }

    public static void processCreativeInv(EntityPlayerMP sender, boolean open) {
        if (open) {
            ServerUtils.openSMPContainer((EntityPlayerMP)sender, (Container)new ContainerCreativeInv((EntityPlayer)sender, new ExtendedCreativeInv(NEIServerConfig.forPlayer(sender.func_70005_c_()), Side.SERVER)), (IGuiPacketSender)new IGuiPacketSender(){

                public void sendPacket(EntityPlayerMP player, int windowId) {
                    PacketCustom packet = new PacketCustom((Object)NEIServerPacketHandler.channel, 23);
                    packet.writeBoolean(true);
                    packet.writeByte(windowId);
                    packet.sendToPlayer((EntityPlayer)player);
                }
            });
        } else {
            sender.func_71128_l();
            PacketCustom packet = new PacketCustom((Object)channel, 23);
            packet.writeBoolean(false);
            packet.sendToPlayer((EntityPlayer)sender);
        }
    }

    private void handleGiveItem(EntityPlayerMP player, PacketCustom packet) {
        NEIServerUtils.givePlayerItem(player, packet.readItemStack(), packet.readBoolean(), packet.readBoolean());
    }

    private void setInventorySlot(EntityPlayerMP player, PacketCustom packet) {
        boolean container = packet.readBoolean();
        short slot = packet.readShort();
        ItemStack item = packet.readItemStack();
        ItemStack old = NEIServerUtils.getSlotContents((EntityPlayer)player, slot, container);
        boolean deleting = item == null || old != null && NEIServerUtils.areStacksSameType(item, old) && item.field_77994_a < old.field_77994_a;
        if (NEIServerConfig.canPlayerPerformAction(player.func_70005_c_(), deleting ? "delete" : "item")) {
            NEIServerUtils.setSlotContents((EntityPlayer)player, slot, item, container);
        }
    }

    @Deprecated
    private void modifyEnchantment(EntityPlayerMP player, int e, int lvl, boolean add) {
        ContainerEnchantmentModifier containerem = (ContainerEnchantmentModifier)player.field_71070_bA;
        if (add) {
            containerem.addEnchantment(e, lvl);
        } else {
            containerem.removeEnchantment(e);
        }
    }

    private void openEnchantmentGui(EntityPlayerMP player) {
        ServerUtils.openSMPContainer((EntityPlayerMP)player, (Container)new ContainerEnchantmentModifier(player.field_71071_by, player.field_70170_p), (IGuiPacketSender)new IGuiPacketSender(){

            public void sendPacket(EntityPlayerMP player, int windowId) {
                PacketCustom packet = new PacketCustom((Object)NEIServerPacketHandler.channel, 21);
                packet.writeByte(windowId);
                packet.sendToPlayer((EntityPlayer)player);
            }
        });
    }

    private void openPotionGui(EntityPlayerMP player, PacketCustom packet) {
        InventoryBasic b = new InventoryBasic("potionStore", true, 9);
        for (int i = 0; i < b.func_70302_i_(); ++i) {
            b.func_70299_a(i, packet.readItemStack());
        }
        ServerUtils.openSMPContainer((EntityPlayerMP)player, (Container)new ContainerPotionCreator(player.field_71071_by, (IInventory)b), (IGuiPacketSender)new IGuiPacketSender(){

            public void sendPacket(EntityPlayerMP player, int windowId) {
                PacketCustom packet = new PacketCustom((Object)NEIServerPacketHandler.channel, 24);
                packet.writeByte(windowId);
                packet.sendToPlayer((EntityPlayer)player);
            }
        });
    }

    public static void sendActionDisabled(int dim, String name, boolean disable) {
        new PacketCustom((Object)channel, 11).writeString(name).writeBoolean(disable).sendToDimension(dim);
    }

    public static void sendActionEnabled(EntityPlayerMP player, String name, boolean enable) {
        new PacketCustom((Object)channel, 12).writeString(name).writeBoolean(enable).sendToPlayer((EntityPlayer)player);
    }

    private void sendLoginState(EntityPlayerMP player) {
        LinkedList<String> actions = new LinkedList<String>();
        LinkedList<String> disabled = new LinkedList<String>();
        LinkedList<String> enabled = new LinkedList<String>();
        LinkedList<ItemStack> bannedItems = new LinkedList<ItemStack>();
        PlayerSave playerSave = NEIServerConfig.forPlayer(player.func_70005_c_());
        for (String string : NEIActions.nameActionMap.keySet()) {
            if (NEIServerConfig.canPlayerPerformAction(player.func_70005_c_(), string)) {
                actions.add(string);
            }
            if (NEIServerConfig.isActionDisabled(player.field_71093_bK, string)) {
                disabled.add(string);
            }
            if (!playerSave.isActionEnabled(string)) continue;
            enabled.add(string);
        }
        for (ItemStackMap.Entry entry : NEIServerConfig.bannedItems.entries()) {
            if (NEIServerConfig.isPlayerInList(player.func_70005_c_(), (Set)entry.value, true)) continue;
            bannedItems.add(entry.key);
        }
        PacketCustom packet = new PacketCustom((Object)channel, 10);
        packet.writeByte(actions.size());
        for (String s : actions) {
            packet.writeString(s);
        }
        packet.writeByte(disabled.size());
        for (String s : disabled) {
            packet.writeString(s);
        }
        packet.writeByte(enabled.size());
        for (String s : enabled) {
            packet.writeString(s);
        }
        packet.writeInt(bannedItems.size());
        for (ItemStack stack : bannedItems) {
            packet.writeItemStack(stack);
        }
        packet.sendToPlayer((EntityPlayer)player);
    }

    public static void sendHasServerSideTo(EntityPlayerMP player) {
        LogHelper.debug("Sending serverside check to: " + player.func_70005_c_());
        PacketCustom packet = new PacketCustom((Object)channel, 1);
        packet.writeByte(0);
        packet.writeString(player.field_70170_p.func_72912_H().func_76065_j());
        packet.sendToPlayer((EntityPlayer)player);
    }

    public static void sendAddMagneticItemTo(EntityPlayerMP player, EntityItem item) {
        PacketCustom packet = new PacketCustom((Object)channel, 13);
        packet.writeInt(item.func_145782_y());
        packet.sendToPlayer((EntityPlayer)player);
    }
}

