/*
 * Decompiled with CFR 0.152.
 */
package ganymedes01.etfuturum.client.skins;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import net.minecraft.client.renderer.ImageBufferDownload;

@SideOnly(value=Side.CLIENT)
public class NewImageBufferDownload
extends ImageBufferDownload {
    private BufferedImage oldStyleImage;
    private int[] imageData;
    private int imageWidth;
    private int imageHeight;

    public BufferedImage func_78432_a(BufferedImage buffImg) {
        if (buffImg == null) {
            return null;
        }
        this.oldStyleImage = super.func_78432_a(buffImg);
        this.imageWidth = 64;
        this.imageHeight = 64;
        BufferedImage buffImg2 = new BufferedImage(this.imageWidth, this.imageHeight, 2);
        Graphics graphics = buffImg2.getGraphics();
        graphics.drawImage(buffImg, 0, 0, null);
        if (buffImg.getHeight() == 32) {
            graphics.drawImage(buffImg2, 24, 48, 20, 52, 4, 16, 8, 20, null);
            graphics.drawImage(buffImg2, 28, 48, 24, 52, 8, 16, 12, 20, null);
            graphics.drawImage(buffImg2, 20, 52, 16, 64, 8, 20, 12, 32, null);
            graphics.drawImage(buffImg2, 24, 52, 20, 64, 4, 20, 8, 32, null);
            graphics.drawImage(buffImg2, 28, 52, 24, 64, 0, 20, 4, 32, null);
            graphics.drawImage(buffImg2, 32, 52, 28, 64, 12, 20, 16, 32, null);
            graphics.drawImage(buffImg2, 40, 48, 36, 52, 44, 16, 48, 20, null);
            graphics.drawImage(buffImg2, 44, 48, 40, 52, 48, 16, 52, 20, null);
            graphics.drawImage(buffImg2, 36, 52, 32, 64, 48, 20, 52, 32, null);
            graphics.drawImage(buffImg2, 40, 52, 36, 64, 44, 20, 48, 32, null);
            graphics.drawImage(buffImg2, 44, 52, 40, 64, 40, 20, 44, 32, null);
            graphics.drawImage(buffImg2, 48, 52, 44, 64, 52, 20, 56, 32, null);
        }
        graphics.dispose();
        this.imageData = ((DataBufferInt)buffImg2.getRaster().getDataBuffer()).getData();
        this.setAreaOpaque(0, 0, 32, 16);
        this.setAreaTransparent(32, 0, 64, 32);
        this.setAreaOpaque(0, 16, 64, 32);
        this.setAreaTransparent(0, 32, 16, 48);
        this.setAreaTransparent(16, 32, 40, 48);
        this.setAreaTransparent(40, 32, 56, 48);
        this.setAreaTransparent(0, 48, 16, 64);
        this.setAreaOpaque(16, 48, 48, 64);
        this.setAreaTransparent(48, 48, 64, 64);
        return buffImg2;
    }

    public BufferedImage getOldSyleImage() {
        return this.oldStyleImage;
    }

    private void setAreaTransparent(int minX, int minY, int maxX, int maxY) {
        if (!this.hasTransparency(minX, minY, maxX, maxY)) {
            for (int x = minX; x < maxX; ++x) {
                for (int y = minY; y < maxY; ++y) {
                    int n = x + y * this.imageWidth;
                    this.imageData[n] = this.imageData[n] & 0xFFFFFF;
                }
            }
        }
    }

    private void setAreaOpaque(int minX, int minY, int maxX, int maxY) {
        for (int i = minX; i < maxX; ++i) {
            for (int j = minY; j < maxY; ++j) {
                int n = i + j * this.imageWidth;
                this.imageData[n] = this.imageData[n] | 0xFF000000;
            }
        }
    }

    private boolean hasTransparency(int minX, int minY, int maxX, int maxY) {
        for (int i = minX; i < maxX; ++i) {
            for (int j = minY; j < maxY; ++j) {
                int colour = this.imageData[i + j * this.imageWidth];
                if ((colour >> 24 & 0xFF) >= 128) continue;
                return true;
            }
        }
        return false;
    }
}

