/*
 * Decompiled with CFR 0.152.
 */
package ganymedes01.etfuturum.core.proxy;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.registry.EntityRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import ganymedes01.etfuturum.EtFuturum;
import ganymedes01.etfuturum.client.gui.inventory.GuiAnvil;
import ganymedes01.etfuturum.client.gui.inventory.GuiEnchantment;
import ganymedes01.etfuturum.client.gui.inventory.GuiNewBrewingStand;
import ganymedes01.etfuturum.configuration.ConfigurationHandler;
import ganymedes01.etfuturum.core.handlers.ServerEventHandler;
import ganymedes01.etfuturum.core.handlers.WorldTickEventHandler;
import ganymedes01.etfuturum.core.utils.Utils;
import ganymedes01.etfuturum.entities.EntityArmourStand;
import ganymedes01.etfuturum.entities.EntityEndermite;
import ganymedes01.etfuturum.entities.EntityLingeringEffect;
import ganymedes01.etfuturum.entities.EntityLingeringPotion;
import ganymedes01.etfuturum.entities.EntityNewSnowGolem;
import ganymedes01.etfuturum.entities.EntityPlacedEndCrystal;
import ganymedes01.etfuturum.entities.EntityRabbit;
import ganymedes01.etfuturum.entities.EntityRespawnedDragon;
import ganymedes01.etfuturum.entities.EntityTippedArrow;
import ganymedes01.etfuturum.entities.EntityZombieVillager;
import ganymedes01.etfuturum.entities.ModEntityList;
import ganymedes01.etfuturum.inventory.ContainerAnvil;
import ganymedes01.etfuturum.inventory.ContainerEnchantment;
import ganymedes01.etfuturum.inventory.ContainerNewBrewingStand;
import ganymedes01.etfuturum.tileentities.TileEntityBanner;
import ganymedes01.etfuturum.tileentities.TileEntityEndRod;
import ganymedes01.etfuturum.tileentities.TileEntityNewBeacon;
import ganymedes01.etfuturum.tileentities.TileEntityNewBrewingStand;
import java.util.LinkedList;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.passive.EntityPig;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.MinecraftForge;

public class CommonProxy
implements IGuiHandler {
    public void registerEvents() {
        FMLCommonHandler.instance().bus().register((Object)new WorldTickEventHandler());
        FMLCommonHandler.instance().bus().register((Object)ConfigurationHandler.INSTANCE);
        FMLCommonHandler.instance().bus().register((Object)ServerEventHandler.INSTANCE);
        MinecraftForge.EVENT_BUS.register((Object)ServerEventHandler.INSTANCE);
    }

    public void registerEntities() {
        if (EtFuturum.enableBanners) {
            GameRegistry.registerTileEntity(TileEntityBanner.class, (String)Utils.getUnlocalisedName("banner"));
        }
        if (EtFuturum.enableArmourStand) {
            ModEntityList.registerEntity(EntityArmourStand.class, "wooden_armorstand", 0, EtFuturum.instance, 64, 1, true);
        }
        if (EtFuturum.enableEndermite) {
            ModEntityList.registerEntity(EntityEndermite.class, "endermite", 1, EtFuturum.instance, 64, 1, true, 0x161616, 0x6E6E6E);
        }
        if (EtFuturum.enableChorusFruit) {
            GameRegistry.registerTileEntity(TileEntityEndRod.class, (String)Utils.getUnlocalisedName("end_rod"));
        }
        if (EtFuturum.enableTippedArrows) {
            ModEntityList.registerEntity(EntityTippedArrow.class, "tipped_arrow", 2, EtFuturum.instance, 64, 20, true);
        }
        if (EtFuturum.enableBrewingStands) {
            GameRegistry.registerTileEntity(TileEntityNewBrewingStand.class, (String)Utils.getUnlocalisedName("brewing_stand"));
        }
        if (EtFuturum.enableColourfulBeacons) {
            GameRegistry.registerTileEntity(TileEntityNewBeacon.class, (String)Utils.getUnlocalisedName("beacon"));
        }
        if (EtFuturum.enableRabbit) {
            ModEntityList.registerEntity(EntityRabbit.class, "rabbit", 3, EtFuturum.instance, 80, 3, true, 10051392, 7555121);
            LinkedList<BiomeGenBase> biomes = new LinkedList<BiomeGenBase>();
            block0: for (BiomeGenBase biome : BiomeGenBase.func_150565_n()) {
                if (biome == null) continue;
                for (Object obj : biome.func_76747_a(EnumCreatureType.creature)) {
                    if (!(obj instanceof BiomeGenBase.SpawnListEntry)) continue;
                    BiomeGenBase.SpawnListEntry entry = (BiomeGenBase.SpawnListEntry)obj;
                    if (entry.field_76300_b != EntityPig.class) continue;
                    biomes.add(biome);
                    continue block0;
                }
            }
            EntityRegistry.addSpawn(EntityRabbit.class, (int)10, (int)3, (int)3, (EnumCreatureType)EnumCreatureType.creature, (BiomeGenBase[])biomes.toArray(new BiomeGenBase[biomes.size()]));
        }
        if (EtFuturum.enableLingeringPotions) {
            ModEntityList.registerEntity(EntityLingeringPotion.class, "lingering_potion", 4, EtFuturum.instance, 64, 10, true);
            ModEntityList.registerEntity(EntityLingeringEffect.class, "lingering_effect", 5, EtFuturum.instance, 64, 1, true);
        }
        if (EtFuturum.enableVillagerZombies) {
            ModEntityList.registerEntity(EntityZombieVillager.class, "villager_zombie", 6, EtFuturum.instance, 80, 3, true, 44975, 7969893);
        }
        if (EtFuturum.enableDragonRespawn) {
            ModEntityList.registerEntity(EntityPlacedEndCrystal.class, "end_crystal", 7, EtFuturum.instance, 256, Integer.MAX_VALUE, false);
            ModEntityList.registerEntity(EntityRespawnedDragon.class, "ender_dragon", 8, EtFuturum.instance, 160, 3, true);
        }
        if (EtFuturum.enableShearableGolems) {
            ModEntityList.registerEntity(EntityNewSnowGolem.class, "snow_golem", 9, EtFuturum.instance, 80, 3, true);
        }
    }

    public void registerRenderers() {
    }

    public Object getServerGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        switch (ID) {
            case 0: {
                return new ContainerEnchantment(player.field_71071_by, world, x, y, z);
            }
            case 1: {
                return new ContainerAnvil(player, world, x, y, z);
            }
            case 2: {
                return new ContainerNewBrewingStand(player.field_71071_by, (TileEntityNewBrewingStand)world.func_147438_o(x, y, z));
            }
        }
        return null;
    }

    public Object getClientGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        switch (ID) {
            case 0: {
                return new GuiEnchantment(player.field_71071_by, world, null);
            }
            case 1: {
                return new GuiAnvil(player, world, x, y, z);
            }
            case 2: {
                return new GuiNewBrewingStand(player.field_71071_by, (TileEntityNewBrewingStand)world.func_147438_o(x, y, z));
            }
        }
        return null;
    }
}

