/*
 * Decompiled with CFR 0.152.
 */
package com.zephaniahnoah.shulkertooltip;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.gui.inventory.GuiChest;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;

@Mod(modid="shulkertooltip", version="1.9.2.2")
public class ShulkerToolTip {
    public static final String MODID = "shulkertooltip";
    private static final KeyBinding enableView = new KeyBinding("key.enableView", 56, "key.categories.shulkerTooltip");
    private static final KeyBinding openShulker = new KeyBinding("key.openShulker", 49, "key.categories.shulkerTooltip");
    private static final KeyBinding toggleView = new KeyBinding("key.toggleView", 47, "key.categories.shulkerTooltip");
    private static final ResourceLocation TEXTURE = new ResourceLocation("shulkertooltip", "textures/gui/shulker_parts.png");

    @Mod.EventHandler
    public void preinit(FMLPreInitializationEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)new EventManager());
        ClientRegistry.registerKeyBinding((KeyBinding)enableView);
        ClientRegistry.registerKeyBinding((KeyBinding)openShulker);
        ClientRegistry.registerKeyBinding((KeyBinding)toggleView);
    }

    private class EventManager
    extends GuiScreen {
        private boolean box = false;
        private final List<Integer> ironChestWidths = Arrays.asList(2, 5, 6);
        private float[] color;
        private boolean show = false;
        private boolean pressed = false;

        private EventManager() {
        }

        @SubscribeEvent
        public void tooltipEvent(ItemTooltipEvent e) {
            if (Keyboard.isKeyDown((int)enableView.func_151463_i()) == this.show && this.box) {
                e.getToolTip().clear();
                e.getToolTip().add("");
            }
        }

        @SubscribeEvent
        public void onClick(GuiScreenEvent.MouseInputEvent e) {
            if (e.getGui() instanceof FakeShulkerBox) {
                e.setCanceled(true);
            }
        }

        private void boxPart(int atX, int atY, int fromX, int fromY, int toX, int toY) {
            GL11.glDisable((int)2929);
            GlStateManager.func_179124_c((float)(this.color[0] + 0.15f), (float)(this.color[1] + 0.15f), (float)(this.color[2] + 0.15f));
            Minecraft.func_71410_x().func_110434_K().func_110577_a(TEXTURE);
            this.func_73729_b(atX, atY, fromX, fromY, toX, toY);
            GL11.glEnable((int)2929);
        }

        private void drawBar(int x, int y, int yStart, int boxWidth, int howTall) {
            this.boxPart(x, y, 0, yStart, 5, howTall);
            for (int i = 0; i < boxWidth + 1; ++i) {
                this.boxPart(x + 4 + i * 18, y, 4, yStart, 18, howTall);
            }
            this.boxPart(x + 4 + (boxWidth + 1) * 18, y, 22, yStart, 6, howTall);
        }

        @SubscribeEvent
        public void event(GuiScreenEvent.DrawScreenEvent.Post event) {
            EntityPlayerSP p = Minecraft.func_71410_x().field_71439_g;
            if (event.getGui() instanceof GuiContainer && ((GuiContainer)event.getGui()).getSlotUnderMouse() != null) {
                ItemStack item = ((GuiContainer)event.getGui()).getSlotUnderMouse().func_75211_c();
                String name = item.func_77973_b().getRegistryName().toString().split(":")[1].replace("_", "");
                if (name.contains("shulkerbox")) {
                    if (Keyboard.isKeyDown((int)toggleView.func_151463_i())) {
                        if (!this.pressed) {
                            this.show = !this.show;
                            this.pressed = true;
                        }
                    } else {
                        this.pressed = false;
                    }
                    for (EnumDyeColor c : EnumDyeColor.values()) {
                        if (name.contains(c.toString().toLowerCase())) {
                            this.color = c.func_193349_f();
                            break;
                        }
                        this.color = new float[]{1.0f, 1.0f, 1.0f};
                    }
                    int boxWidth = this.ironChestWidths.contains(item.func_77960_j()) ? 11 : 8;
                    NBTTagList nbttaglist = (item.func_77942_o() ? item.func_77978_p() : new NBTTagCompound()).func_74775_l("BlockEntityTag").func_150295_c("Items", 10);
                    int slot = 0;
                    ArrayList<ItemStack> boxContents = new ArrayList<ItemStack>();
                    for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
                        ItemStack stack = new ItemStack((NBTTagCompound)nbttaglist.func_179238_g(i));
                        String stringofitems = nbttaglist.func_179238_g(i).toString();
                        int slotnum = Integer.parseInt(stringofitems.substring(stringofitems.indexOf("{Slot:") + 1, stringofitems.indexOf("b,")).replaceAll("[^0-9]", ""));
                        while (slot != slotnum) {
                            ++slot;
                            boxContents.add(ItemStack.field_190927_a);
                        }
                        ++slot;
                        boxContents.add(stack);
                    }
                    slot %= boxWidth + 1;
                    while (boxWidth + 1 > slot && slot != 0) {
                        ++slot;
                        boxContents.add(ItemStack.field_190927_a);
                    }
                    if (Keyboard.isKeyDown((int)openShulker.func_151463_i())) {
                        if (boxWidth != 8 || boxContents.size() > 54) {
                            p.func_145747_a((ITextComponent)new TextComponentString("\u00a7cERROR: Chest contents wouldn't fit in GUI."));
                        }
                        InventoryBasic inventory = new InventoryBasic(item.func_82833_r(), item.func_82837_s(), boxContents.size() < 27 ? 27 : boxContents.size());
                        for (int i = 0; i < boxContents.size(); ++i) {
                            inventory.func_70299_a(i, (ItemStack)boxContents.get(i));
                        }
                        Minecraft.func_71410_x().func_147108_a((GuiScreen)new FakeShulkerBox((IInventory)p.field_71071_by, (IInventory)inventory));
                    }
                    if (Keyboard.isKeyDown((int)enableView.func_151463_i()) == this.show) {
                        int lengthOver = event.getMouseX() + 32 + boxWidth * 18 - new ScaledResolution(Minecraft.func_71410_x()).func_78326_a();
                        int toolTipHeight = 8 + (boxContents.size() - 1) / boxWidth * 18;
                        int centerToolTip = toolTipHeight / 2;
                        int lengthAbove = event.getMouseY() - 23 - centerToolTip;
                        int lengthBelow = event.getMouseY() - 10 + toolTipHeight - new ScaledResolution(Minecraft.func_71410_x()).func_78328_b() - centerToolTip;
                        this.box = true;
                        int drawX = event.getMouseX() + 4 - (lengthOver > 0 ? lengthOver : 0);
                        int drawY = event.getMouseY() - 12 - centerToolTip - (lengthBelow > 0 ? lengthBelow : 0) - (lengthAbove < 0 ? lengthAbove : 0);
                        GlStateManager.func_179094_E();
                        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)777.0f);
                        RenderHelper.func_74520_c();
                        this.drawBar(drawX, drawY - 11, 0, boxWidth, 16);
                        Minecraft.func_71410_x().field_71466_p.func_175063_a(item.func_82833_r(), (float)(drawX + 6), (float)(drawY - 6), 0xFFFFFF);
                        int row = 0;
                        slot = 0;
                        int x = 0;
                        int y = drawY + 6 + 18 * row;
                        this.boxPart(drawX, drawY + 5, 0, 4, 5, 18);
                        this.boxPart(drawX + (boxWidth + 1) * 18 + 5, drawY + 5, 23, 5, 5, 18);
                        for (int i = 0; i < boxContents.size(); ++i) {
                            if (slot > boxWidth) {
                                slot = 0;
                                this.boxPart(drawX, drawY + 5 + 18 * ++row, 0, 4, 5, 18);
                                this.boxPart(drawX + (boxWidth + 1) * 18 + 5, drawY + 5 + 18 * row, 23, 5, 5, 18);
                            }
                            x = drawX + 6 + 18 * slot;
                            y = drawY + 6 + 18 * row;
                            this.boxPart(x - 1, y - 1, 5, 17, 18, 18);
                            Minecraft.func_71410_x().func_175599_af().func_180450_b((ItemStack)boxContents.get(i), x, y);
                            Minecraft.func_71410_x().func_175599_af().func_180453_a(Minecraft.func_71410_x().field_71466_p, (ItemStack)boxContents.get(i), x, y, ((ItemStack)boxContents.get(i)).func_190916_E() == 1 ? "" : Integer.toString(((ItemStack)boxContents.get(i)).func_190916_E()));
                            ++slot;
                        }
                        while (boxWidth + 1 > slot) {
                            x = drawX + 6 + 18 * slot;
                            this.boxPart(x - 1, y - 1, 5, 17, 18, 18);
                            ++slot;
                        }
                        this.drawBar(drawX, drawY + (row + 1) * 18 + 5, 35, boxWidth, 5);
                        GlStateManager.func_179121_F();
                    }
                } else {
                    this.box = false;
                }
            }
        }
    }

    private class FakeShulkerBox
    extends GuiChest {
        public FakeShulkerBox(IInventory upperInv, IInventory lowerInv) {
            super(upperInv, lowerInv);
        }
    }
}

