/*
 * Decompiled with CFR 0.152.
 */
package com.zephaniahnoah.shulkertooltip;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.ContainerScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.ClientRegistry;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.client.settings.IKeyConflictContext;
import net.minecraftforge.client.settings.KeyConflictContext;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

@Mod(value="shulkertooltip")
public class ShulkerToolTip {
    public static final String MODID = "shulkertooltip";
    private static final KeyMapping enableView = new KeyMapping("key.enableView", (IKeyConflictContext)KeyConflictContext.GUI, InputConstants.Type.KEYSYM, 342, "key.categories.shulkerTooltip");
    private static final KeyMapping openShulker = new KeyMapping("key.openShulker", (IKeyConflictContext)KeyConflictContext.GUI, InputConstants.Type.KEYSYM, 78, "key.categories.shulkerTooltip");
    private static final KeyMapping toggleView = new KeyMapping("key.toggleView", (IKeyConflictContext)KeyConflictContext.GUI, InputConstants.Type.KEYSYM, 86, "key.categories.shulkerTooltip");
    private static final ResourceLocation TEXTURE = new ResourceLocation("shulkertooltip", "textures/gui/shulker_parts.png");

    public ShulkerToolTip() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::setup);
    }

    private void setup(FMLCommonSetupEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)new EventManager());
        ClientRegistry.registerKeyBinding((KeyMapping)enableView);
        ClientRegistry.registerKeyBinding((KeyMapping)openShulker);
        ClientRegistry.registerKeyBinding((KeyMapping)toggleView);
    }

    private class EventManager
    extends GuiComponent {
        private boolean box = false;
        private final List<String> ironChestWidths = Arrays.asList("diamond", "crystal", "obsidian");
        private final String[] boxNames = new String[]{"shulker_box", "end_troll_box"};
        private float[] color;
        private boolean show = false;
        private boolean pressed = false;

        private EventManager() {
        }

        private String shulkerStorageItem(ItemStack stack) {
            String name = stack.m_41720_().getRegistryName().toString();
            for (String n : this.boxNames) {
                if (!name.contains(n)) continue;
                return name;
            }
            return null;
        }

        @SubscribeEvent
        public void tooltipEvent(ItemTooltipEvent e) {
            if (this.shulkerStorageItem(e.getItemStack()) != null && (enableView.getKey().m_84873_() == -1 || enableView.getKey().m_84873_() != -1 && InputConstants.m_84830_((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)enableView.getKey().m_84873_()) == this.show && this.box)) {
                e.getToolTip().clear();
                e.getToolTip().add(new TextComponent(""));
            }
        }

        @SubscribeEvent
        public void onClick(ScreenEvent.MouseClickedEvent e) {
            if (e.getScreen() instanceof FakeShulkerBox) {
                e.setCanceled(true);
            }
        }

        void boxPart(PoseStack m, int atX, int atY, int fromX, int fromY, int toX, int toY) {
            if (this.color != null) {
                RenderSystem.m_157429_((float)(this.color[0] + 0.15f), (float)(this.color[1] + 0.15f), (float)(this.color[2] + 0.15f), (float)1.0f);
            }
            RenderSystem.m_157456_((int)0, (ResourceLocation)TEXTURE);
            this.m_93228_(m, atX, atY, fromX, fromY, toX, toY);
        }

        private void drawBar(PoseStack m, int x, int y, int yStart, int boxWidth, int howTall) {
            this.boxPart(m, x, y, 0, yStart, 5, howTall);
            for (int i = 0; i < boxWidth + 1; ++i) {
                this.boxPart(m, x + 4 + i * 18, y, 4, yStart, 18, howTall);
            }
            this.boxPart(m, x + 4 + (boxWidth + 1) * 18, y, 22, yStart, 6, howTall);
        }

        @SubscribeEvent
        public void event(ScreenEvent.DrawScreenEvent.Post event) {
            Minecraft mc = Minecraft.m_91087_();
            long window = mc.m_91268_().m_85439_();
            LocalPlayer p = mc.f_91074_;
            if (event.getScreen() instanceof AbstractContainerScreen && ((AbstractContainerScreen)event.getScreen()).getSlotUnderMouse() != null) {
                ItemStack item = ((AbstractContainerScreen)event.getScreen()).getSlotUnderMouse().m_7993_();
                String name = this.shulkerStorageItem(item);
                if (name != null) {
                    if (toggleView.getKey().m_84873_() != -1 && InputConstants.m_84830_((long)window, (int)toggleView.getKey().m_84873_())) {
                        if (!this.pressed) {
                            this.show = !this.show;
                            this.pressed = true;
                        }
                    } else {
                        this.pressed = false;
                    }
                    for (DyeColor c : DyeColor.values()) {
                        if (name.contains(c.toString().toLowerCase().replace("_", ""))) {
                            this.color = c.m_41068_();
                            break;
                        }
                        this.color = null;
                    }
                    int boxWidth = this.ironChestWidths.contains(item.m_41720_().getRegistryName().toString().split(":")[1].split("_")[0]) ? 11 : 8;
                    ListTag nbttaglist = (item.m_41782_() ? item.m_41783_() : new CompoundTag()).m_128469_("BlockEntityTag").m_128437_("Items", 10);
                    int slot = 0;
                    ArrayList<ItemStack> boxContents = new ArrayList<ItemStack>();
                    for (int i = 0; i < nbttaglist.size(); ++i) {
                        ItemStack stack = ItemStack.m_41712_((CompoundTag)((CompoundTag)nbttaglist.get(i)));
                        String stringofitems = nbttaglist.get(i).toString();
                        int slotnum = Integer.parseInt(stringofitems.split("Slot:")[1].split("b,")[0].replaceAll("[^0-9]", ""));
                        while (slot != slotnum) {
                            ++slot;
                            boxContents.add(ItemStack.f_41583_);
                        }
                        ++slot;
                        boxContents.add(stack);
                    }
                    slot %= boxWidth + 1;
                    while (boxWidth + 1 > slot && slot != 0) {
                        ++slot;
                        boxContents.add(ItemStack.f_41583_);
                    }
                    if (openShulker.getKey().m_84873_() != -1 && InputConstants.m_84830_((long)window, (int)openShulker.getKey().m_84873_())) {
                        if (boxWidth != 8 || boxContents.size() > 54) {
                            p.m_6352_((Component)new TextComponent("\u00a7cERROR: Chest contents wouldn't fit in GUI."), UUID.randomUUID());
                        }
                        SimpleContainer inventory = new SimpleContainer(boxContents.size() < 27 ? 27 : boxContents.size());
                        for (int i = 0; i < boxContents.size(); ++i) {
                            inventory.m_6836_(i, (ItemStack)boxContents.get(i));
                        }
                        ChestMenu container = new ChestMenu(MenuType.f_39959_, p.f_36096_.f_38840_, p.m_150109_(), (Container)inventory, 3);
                        mc.m_91152_((Screen)new FakeShulkerBox(container, p.m_150109_(), item.m_41611_()));
                    }
                    if (enableView.getKey().m_84873_() == -1 || enableView.getKey().m_84873_() != -1 && InputConstants.m_84830_((long)window, (int)enableView.getKey().m_84873_()) == this.show) {
                        int lengthOver = event.getMouseX() + 32 + boxWidth * 18 - mc.m_91268_().m_85441_();
                        int toolTipHeight = 8 + (boxContents.size() - 1) / boxWidth * 18;
                        int centerToolTip = toolTipHeight / 2;
                        int lengthAbove = event.getMouseY() - 23 - centerToolTip;
                        int lengthBelow = event.getMouseY() - 10 + toolTipHeight - mc.m_91268_().m_85442_() - centerToolTip;
                        this.box = true;
                        int drawX = event.getMouseX() + 4 - (lengthOver > 0 ? lengthOver : 0);
                        int drawY = event.getMouseY() - 12 - centerToolTip - (lengthBelow > 0 ? lengthBelow : 0) - (lengthAbove < 0 ? lengthAbove : 0);
                        PoseStack poseStack = event.getPoseStack();
                        RenderSystem.m_69465_();
                        RenderSystem.m_157191_().m_85837_(0.0, 0.0, 777.0);
                        this.drawBar(poseStack, drawX, drawY - 11, 0, boxWidth, 16);
                        PoseStack stack = event.getPoseStack();
                        stack.m_85836_();
                        stack.m_85837_(0.0, 0.0, 777.0);
                        mc.f_91062_.m_92750_(stack, item.m_41611_().getString().replace("[", "").replace("]", ""), (float)(drawX + 6), (float)(drawY - 6), 0xFFFFFF);
                        stack.m_85849_();
                        int row = 0;
                        slot = 0;
                        int x = 0;
                        int y = drawY + 6 + 18 * row;
                        this.boxPart(poseStack, drawX, drawY + 5, 0, 4, 5, 18);
                        this.boxPart(poseStack, drawX + (boxWidth + 1) * 18 + 5, drawY + 5, 23, 5, 5, 18);
                        for (int i = 0; i < boxContents.size(); ++i) {
                            if (slot > boxWidth) {
                                slot = 0;
                                this.boxPart(poseStack, drawX, drawY + 5 + 18 * ++row, 0, 4, 5, 18);
                                this.boxPart(poseStack, drawX + (boxWidth + 1) * 18 + 5, drawY + 5 + 18 * row, 23, 5, 5, 18);
                            }
                            x = drawX + 6 + 18 * slot;
                            y = drawY + 6 + 18 * row;
                            this.boxPart(poseStack, x - 1, y - 1, 5, 17, 18, 18);
                            mc.m_91291_().m_115123_((ItemStack)boxContents.get(i), x, y);
                            String string = Integer.toString(((ItemStack)boxContents.get(i)).m_41613_());
                            if (((ItemStack)boxContents.get(i)).m_41613_() == 1) {
                                string = "";
                            }
                            mc.m_91291_().m_115174_(mc.f_91062_, (ItemStack)boxContents.get(i), x, y, string);
                            ++slot;
                        }
                        while (boxWidth + 1 > slot) {
                            x = drawX + 6 + 18 * slot;
                            this.boxPart(poseStack, x - 1, y - 1, 5, 17, 18, 18);
                            ++slot;
                        }
                        this.drawBar(poseStack, drawX, drawY + (row + 1) * 18 + 5, 35, boxWidth, 5);
                    }
                    RenderSystem.m_69482_();
                } else {
                    this.box = false;
                }
            }
        }
    }

    private class FakeShulkerBox
    extends ContainerScreen {
        public FakeShulkerBox(ChestMenu container, Inventory inventory, Component name) {
            super(container, inventory, name);
        }
    }
}

