/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.betterdeserttemples.world.processor;

import com.mojang.serialization.MapCodec;
import com.yungnickyoung.minecraft.betterdeserttemples.BetterDesertTemplesCommon;
import com.yungnickyoung.minecraft.betterdeserttemples.module.StructureProcessorModule;
import com.yungnickyoung.minecraft.betterdeserttemples.world.ArmorStandChances;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
public class ArmorStandProcessor
extends StructureProcessor {
    public static final ArmorStandProcessor INSTANCE = new ArmorStandProcessor();
    public static final MapCodec<StructureProcessor> CODEC = MapCodec.unit(() -> INSTANCE);

    public StructureTemplate.StructureEntityInfo processEntity(LevelReader levelReader, BlockPos structurePiecePos, StructureTemplate.StructureEntityInfo localEntityInfo, StructureTemplate.StructureEntityInfo globalEntityInfo, StructurePlaceSettings structurePlaceSettings, StructureTemplate template) {
        if (globalEntityInfo.nbt.getString("id").equals("minecraft:armor_stand")) {
            String helmetString;
            String chestplateString;
            String leggingsString;
            String bootsString;
            String helmet;
            ListTag armorItems = globalEntityInfo.nbt.getList("ArmorItems", 10);
            RandomSource randomSource = structurePlaceSettings.getRandom(globalEntityInfo.blockPos);
            try {
                helmet = ((CompoundTag)armorItems.get(3)).get("id").toString();
            }
            catch (Exception e) {
                BetterDesertTemplesCommon.LOGGER.info("Unable to randomize armor stand at {}. Missing helmet?", (Object)globalEntityInfo.blockPos);
                return globalEntityInfo;
            }
            boolean isArmory = helmet.equals("\"minecraft:iron_helmet\"");
            CompoundTag newNBT = globalEntityInfo.nbt.copy();
            ListTag armorItemsList = newNBT.getList("ArmorItems", 10);
            String string = bootsString = isArmory ? ForgeRegistries.ITEMS.getKey((Object)ArmorStandChances.get().getArmoryBoots(randomSource)).toString() : ForgeRegistries.ITEMS.getKey((Object)ArmorStandChances.get().getWardrobeBoots(randomSource)).toString();
            if (!bootsString.equals("minecraft:air")) {
                armorItemsList.getCompound(0).putString("id", bootsString);
                armorItemsList.getCompound(0).putByte("Count", (byte)1);
                armorItemsList.getCompound(0).put("tag", (Tag)Util.make((Object)new CompoundTag(), compoundTag -> compoundTag.putInt("Damage", 0)));
            }
            String string2 = leggingsString = isArmory ? ForgeRegistries.ITEMS.getKey((Object)ArmorStandChances.get().getArmoryLeggings(randomSource)).toString() : ForgeRegistries.ITEMS.getKey((Object)ArmorStandChances.get().getWardrobeLeggings(randomSource)).toString();
            if (!leggingsString.equals("minecraft:air")) {
                armorItemsList.getCompound(1).putString("id", leggingsString);
                armorItemsList.getCompound(1).putByte("Count", (byte)1);
                armorItemsList.getCompound(1).put("tag", (Tag)Util.make((Object)new CompoundTag(), compoundTag -> compoundTag.putInt("Damage", 0)));
            }
            String string3 = chestplateString = isArmory ? ForgeRegistries.ITEMS.getKey((Object)ArmorStandChances.get().getArmoryChestplate(randomSource)).toString() : ForgeRegistries.ITEMS.getKey((Object)ArmorStandChances.get().getWardrobeChestplate(randomSource)).toString();
            if (!chestplateString.equals("minecraft:air")) {
                armorItemsList.getCompound(2).putString("id", chestplateString);
                armorItemsList.getCompound(2).putByte("Count", (byte)1);
                armorItemsList.getCompound(2).put("tag", (Tag)Util.make((Object)new CompoundTag(), compoundTag -> compoundTag.putInt("Damage", 0)));
            }
            String string4 = helmetString = isArmory ? ForgeRegistries.ITEMS.getKey((Object)ArmorStandChances.get().getArmoryHelmet(randomSource)).toString() : ForgeRegistries.ITEMS.getKey((Object)ArmorStandChances.get().getWardrobeHelmet(randomSource)).toString();
            if (!helmetString.equals("minecraft:air")) {
                armorItemsList.getCompound(3).putString("id", helmetString);
                armorItemsList.getCompound(3).putByte("Count", (byte)1);
                armorItemsList.getCompound(3).put("tag", (Tag)Util.make((Object)new CompoundTag(), compoundTag -> compoundTag.putInt("Damage", 0)));
            }
            globalEntityInfo = new StructureTemplate.StructureEntityInfo(globalEntityInfo.pos, globalEntityInfo.blockPos, newNBT);
        }
        return globalEntityInfo;
    }

    @Nullable
    public StructureTemplate.StructureBlockInfo processBlock(LevelReader levelReader, BlockPos jigsawPiecePos, BlockPos jigsawPieceBottomCenterPos, StructureTemplate.StructureBlockInfo blockInfoLocal, StructureTemplate.StructureBlockInfo blockInfoGlobal, StructurePlaceSettings structurePlacementData) {
        return blockInfoGlobal;
    }

    protected StructureProcessorType<?> getType() {
        return StructureProcessorModule.ARMOR_STAND_PROCESSOR;
    }
}

