/*
 * Decompiled with CFR 0.152.
 */
package com.oitsjustjose.geolosys.api.world;

import com.oitsjustjose.geolosys.api.world.DepositUtils;
import com.oitsjustjose.geolosys.capability.deposit.IDepositCapability;
import com.oitsjustjose.geolosys.capability.world.IChunkGennedCapability;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.state.BlockState;

public interface IDeposit {
    public int generate(WorldGenLevel var1, BlockPos var2, IDepositCapability var3, IChunkGennedCapability var4);

    public void afterGen(WorldGenLevel var1, BlockPos var2, IDepositCapability var3, IChunkGennedCapability var4);

    public HashSet<BlockState> getAllOres();

    public int getGenWt();

    public boolean canPlaceInBiome(Holder<Biome> var1);

    public HashSet<BlockState> getBlockStateMatchers();

    default public void validate(HashMap<String, HashMap<BlockState, Float>> oreBlocks, HashMap<BlockState, Float> sampleBlocks) {
        if (!oreBlocks.containsKey("default")) {
            throw new RuntimeException("Pluton blocks should always have a default key");
        }
        HashMap<String, Float> cumulOreWtMap = new HashMap<String, Float>();
        for (Map.Entry<String, HashMap<BlockState, Float>> i : oreBlocks.entrySet()) {
            if (!cumulOreWtMap.containsKey(i.getKey())) {
                cumulOreWtMap.put(i.getKey(), Float.valueOf(0.0f));
            }
            for (Map.Entry<BlockState, Float> j : i.getValue().entrySet()) {
                cumulOreWtMap.compute(i.getKey(), (k, v) -> Float.valueOf(v.floatValue() + ((Float)j.getValue()).floatValue()));
            }
            if (DepositUtils.nearlyEquals(((Float)cumulOreWtMap.get(i.getKey())).floatValue(), 1.0f)) continue;
            throw new RuntimeException("Sum of weights for pluton blocks should equal 1.0");
        }
        float sumWtSamples = 0.0f;
        for (Map.Entry<BlockState, Float> e : sampleBlocks.entrySet()) {
            sumWtSamples += e.getValue().floatValue();
        }
        if (sumWtSamples != 0.0f && !DepositUtils.nearlyEquals(sumWtSamples, 1.0f)) {
            throw new RuntimeException("Sum of weights for pluton samples should equal 1.0");
        }
    }
}

