/*
 * Decompiled with CFR 0.152.
 */
package com.oitsjustjose.geolosys.api.world.deposit;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.oitsjustjose.geolosys.Geolosys;
import com.oitsjustjose.geolosys.api.world.DepositUtils;
import com.oitsjustjose.geolosys.api.world.IDeposit;
import com.oitsjustjose.geolosys.capability.deposit.IDepositCapability;
import com.oitsjustjose.geolosys.capability.world.IChunkGennedCapability;
import com.oitsjustjose.geolosys.common.config.CommonConfig;
import com.oitsjustjose.geolosys.common.data.serializer.SerializerUtils;
import com.oitsjustjose.geolosys.common.utils.Utils;
import com.oitsjustjose.geolosys.common.world.feature.FeatureUtils;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;

public class TopLayerDeposit
implements IDeposit {
    public static final String JSON_TYPE = "geolosys:deposit_top_layer";
    private final HashMap<String, HashMap<BlockState, Float>> oreToWtMap;
    private final HashMap<BlockState, Float> sampleToWtMap;
    private final int radius;
    private final int depth;
    private final float sampleChance;
    private final int genWt;
    private final HashSet<BlockState> blockStateMatchers;
    private final TagKey<Biome> biomeTag;

    public TopLayerDeposit(HashMap<String, HashMap<BlockState, Float>> oreBlocks, HashMap<BlockState, Float> sampleBlocks, int radius, int depth, float sampleChance, int genWt, TagKey<Biome> biomeTag, HashSet<BlockState> blockStateMatchers) {
        this.oreToWtMap = oreBlocks;
        this.sampleToWtMap = sampleBlocks;
        this.radius = radius;
        this.depth = depth;
        this.sampleChance = sampleChance;
        this.genWt = genWt;
        this.biomeTag = biomeTag;
        this.blockStateMatchers = blockStateMatchers;
        this.validate(oreBlocks, sampleBlocks);
    }

    @Nullable
    public BlockState getOre(BlockState currentState, RandomSource rand) {
        String res = Utils.getRegistryName(currentState);
        if (this.oreToWtMap.containsKey(res)) {
            HashMap<BlockState, Float> mp = this.oreToWtMap.get(res);
            return DepositUtils.pick(mp, rand);
        }
        return DepositUtils.pick(this.oreToWtMap.get("default"), rand);
    }

    @Nullable
    public BlockState getSample(RandomSource rand) {
        return DepositUtils.pick(this.sampleToWtMap, rand);
    }

    @Override
    @Nullable
    public HashSet<BlockState> getAllOres() {
        return null;
    }

    @Override
    public boolean canPlaceInBiome(Holder<Biome> b) {
        return b.m_203656_(this.biomeTag);
    }

    @Override
    public int getGenWt() {
        return this.genWt;
    }

    public String toString() {
        return "Top Layer deposit with Blocks=" + this.getAllOres() + ", Samples=" + Arrays.toString(this.sampleToWtMap.keySet().toArray()) + ", Radius=" + this.radius + ", Depth=" + this.depth;
    }

    @Override
    public int generate(WorldGenLevel level, BlockPos pos, IDepositCapability deposits, IChunkGennedCapability chunksGenerated) {
        if (!this.canPlaceInBiome((Holder<Biome>)level.m_204166_(pos))) {
            return 0;
        }
        int totlPlaced = 0;
        ChunkPos thisChunk = new ChunkPos(pos);
        int x = (thisChunk.m_45604_() + thisChunk.m_45608_()) / 2 - level.m_213780_().m_188503_(8) + level.m_213780_().m_188503_(16);
        int z = (thisChunk.m_45605_() + thisChunk.m_45609_()) / 2 - level.m_213780_().m_188503_(8) + level.m_213780_().m_188503_(16);
        int radX = this.radius / 2 + level.m_213780_().m_188503_(this.radius / 2);
        int radZ = this.radius / 2 + level.m_213780_().m_188503_(this.radius / 2);
        BlockPos basePos = new BlockPos(x, 0, z);
        for (int dX = -radX; dX <= radX; ++dX) {
            for (int dZ = -radZ; dZ <= radZ; ++dZ) {
                if (dX * dX + dZ * dZ > this.radius + level.m_213780_().m_188503_(Math.max(1, this.radius / 2))) continue;
                BlockPos baseForXZ = Utils.getTopSolidBlock((LevelReader)level, basePos.m_7918_(dX, 0, dZ));
                for (int i = 0; i < this.depth; ++i) {
                    BlockState smpl;
                    boolean isTop;
                    BlockPos placePos = baseForXZ.m_6625_(i);
                    BlockState current = level.m_8055_(placePos);
                    BlockState tmp = this.getOre(current, level.m_213780_());
                    boolean bl = isTop = i == 0;
                    if (tmp == null) continue;
                    if (tmp.m_61138_((Property)BlockStateProperties.f_61427_)) {
                        tmp = (BlockState)tmp.m_61124_((Property)BlockStateProperties.f_61427_, (Comparable)Boolean.valueOf(!isTop));
                    }
                    if (!this.getBlockStateMatchers().contains(current) && !this.oreToWtMap.containsKey(Utils.getRegistryName(current)) || !FeatureUtils.enqueueBlockPlacement(level, thisChunk, placePos, tmp, deposits, chunksGenerated)) continue;
                    ++totlPlaced;
                    if (!isTop || !(level.m_213780_().m_188501_() <= this.sampleChance) || (smpl = this.getSample(level.m_213780_())) == null) continue;
                    FeatureUtils.enqueueBlockPlacement(level, thisChunk, placePos.m_7494_(), smpl, deposits, chunksGenerated);
                    FeatureUtils.fixSnowyBlock(level, placePos);
                }
            }
        }
        return totlPlaced;
    }

    @Override
    public void afterGen(WorldGenLevel level, BlockPos pos, IDepositCapability deposits, IChunkGennedCapability chunksGenerated) {
        if (((Boolean)CommonConfig.DEBUG_WORLD_GEN.get()).booleanValue()) {
            Geolosys.getInstance().LOGGER.info("Generated {} in Chunk {} (Pos [{} {} {}])", (Object)this.toString(), (Object)new ChunkPos(pos), (Object)pos.m_123341_(), (Object)pos.m_123342_(), (Object)pos.m_123343_());
        }
    }

    @Override
    public HashSet<BlockState> getBlockStateMatchers() {
        return this.blockStateMatchers == null ? DepositUtils.getDefaultMatchers() : this.blockStateMatchers;
    }

    public static TopLayerDeposit deserialize(JsonObject json) {
        if (json == null) {
            return null;
        }
        try {
            HashMap<String, HashMap<BlockState, Float>> oreBlocks = SerializerUtils.buildMultiBlockMatcherMap(json.get("blocks").getAsJsonObject());
            HashMap<BlockState, Float> sampleBlocks = SerializerUtils.buildMultiBlockMap(json, "samples");
            int radius = json.get("radius").getAsInt();
            int depth = json.get("depth").getAsInt();
            float sampleChance = json.get("chanceForSample").getAsFloat();
            int genWt = json.get("generationWeight").getAsInt();
            TagKey biomeTag = TagKey.m_203882_((ResourceKey)Registries.f_256952_, (ResourceLocation)new ResourceLocation(json.get("biomeTag").getAsString().replace("#", "")));
            HashSet<BlockState> blockStateMatchers = DepositUtils.getDefaultMatchers();
            if (json.has("blockStateMatchers")) {
                blockStateMatchers = SerializerUtils.toBlockStateList(json.get("blockStateMatchers").getAsJsonArray());
            }
            return new TopLayerDeposit(oreBlocks, sampleBlocks, radius, depth, sampleChance, genWt, (TagKey<Biome>)biomeTag, blockStateMatchers);
        }
        catch (Exception e) {
            Geolosys.getInstance().LOGGER.error("Failed to parse: {}", (Object)e.getMessage());
            return null;
        }
    }

    public JsonElement serialize() {
        JsonObject json = new JsonObject();
        JsonObject config = new JsonObject();
        config.add("blocks", (JsonElement)SerializerUtils.deconstructMultiBlockMatcherMap(this.oreToWtMap));
        config.add("samples", (JsonElement)SerializerUtils.deconstructMultiBlockMap(this.sampleToWtMap));
        config.addProperty("radius", (Number)this.radius);
        config.addProperty("depth", (Number)this.depth);
        config.addProperty("chanceForSample", (Number)Float.valueOf(this.sampleChance));
        config.addProperty("generationWeight", (Number)this.genWt);
        config.addProperty("biomeTag", this.biomeTag.f_203868_().toString());
        json.addProperty("type", JSON_TYPE);
        json.add("config", (JsonElement)config);
        return json;
    }
}

