/*
 * Decompiled with CFR 0.152.
 */
package com.oitsjustjose.geolosys.capability.deposit;

import com.oitsjustjose.geolosys.capability.deposit.IDepositCapability;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.registries.ForgeRegistries;

public class DepositCapability
implements IDepositCapability {
    private final ConcurrentHashMap<ChunkPos, ConcurrentLinkedQueue<PendingBlock>> pendingBlocks = new ConcurrentHashMap();
    public static final Capability<IDepositCapability> CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<IDepositCapability>(){});

    @Override
    public int getPendingBlockCount() {
        return (int)this.pendingBlocks.values().stream().collect(Collectors.summarizingInt(ConcurrentLinkedQueue::size)).getSum();
    }

    @Override
    public void putPendingBlock(BlockPos pos, BlockState state) {
        PendingBlock p = new PendingBlock(pos, state);
        ChunkPos cp = new ChunkPos(pos);
        this.pendingBlocks.putIfAbsent(cp, new ConcurrentLinkedQueue());
        this.pendingBlocks.get(cp).add(p);
    }

    @Override
    public void removePendingBlocksForChunk(ChunkPos cp) {
        this.pendingBlocks.remove(cp);
    }

    @Override
    public ConcurrentLinkedQueue<PendingBlock> getPendingBlocks(ChunkPos chunkPos) {
        return this.pendingBlocks.getOrDefault(chunkPos, new ConcurrentLinkedQueue());
    }

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag compound = new CompoundTag();
        this.pendingBlocks.forEach((pos, pending) -> {
            ListTag p = new ListTag();
            String key = pos.f_45578_ + "_" + pos.f_45579_;
            pending.forEach(pb -> p.add((Object)pb.serialize()));
            compound.m_128365_(key, (Tag)p);
        });
        return compound;
    }

    @Override
    public void deserializeNBT(CompoundTag compound) {
        compound.m_128431_().forEach(chunkPosAsString -> {
            String[] parts = chunkPosAsString.split("_");
            ChunkPos cp = new ChunkPos(Integer.parseInt(parts[0]), Integer.parseInt(parts[1]));
            ListTag pending = compound.m_128437_(chunkPosAsString, 10);
            ConcurrentLinkedQueue lq = new ConcurrentLinkedQueue();
            pending.forEach(x -> {
                PendingBlock pb = PendingBlock.deserialize(x);
                if (pb != null) {
                    lq.add(pb);
                }
            });
            this.pendingBlocks.put(cp, lq);
        });
    }

    public record PendingBlock(BlockPos pos, BlockState state) {
        public CompoundTag serialize() {
            CompoundTag tmp = new CompoundTag();
            CompoundTag posTag = NbtUtils.m_129224_((BlockPos)this.pos);
            CompoundTag stateTag = NbtUtils.m_129202_((BlockState)this.state);
            tmp.m_128365_("pos", (Tag)posTag);
            tmp.m_128365_("state", (Tag)stateTag);
            return tmp;
        }

        @Nullable
        public static PendingBlock deserialize(Tag t) {
            if (t instanceof CompoundTag) {
                CompoundTag tag = (CompoundTag)t;
                BlockPos pos = NbtUtils.m_129239_((CompoundTag)tag.m_128469_("pos"));
                BlockState state = NbtUtils.m_247651_((HolderGetter)BuiltInRegistries.f_256975_.m_255303_(), (CompoundTag)tag.m_128469_("state"));
                return new PendingBlock(pos, state);
            }
            return null;
        }

        @Override
        public String toString() {
            return "[" + this.pos.m_123341_() + " " + this.pos.m_123342_() + " " + this.pos.m_123343_() + "]: " + ForgeRegistries.BLOCKS.getKey((Object)this.state.m_60734_());
        }
    }
}

