/*
 * Decompiled with CFR 0.152.
 */
package com.oitsjustjose.geolosys.common;

import com.google.common.collect.Lists;
import com.mojang.serialization.Codec;
import com.oitsjustjose.geolosys.common.blocks.OreBlock;
import com.oitsjustjose.geolosys.common.blocks.PeatBlock;
import com.oitsjustjose.geolosys.common.blocks.PlantBlock;
import com.oitsjustjose.geolosys.common.blocks.SampleBlock;
import com.oitsjustjose.geolosys.common.items.FuelItem;
import com.oitsjustjose.geolosys.common.items.ProPickItem;
import com.oitsjustjose.geolosys.common.world.feature.DepositFeature;
import com.oitsjustjose.geolosys.common.world.feature.RemoveVeinsFeature;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.material.MapColor;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class Registry {
    public final DeferredRegister<Block> BlockRegistry = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"geolosys");
    public final DeferredRegister<Item> ItemRegistry = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"geolosys");
    public final DeferredRegister<Feature<?>> FeatureRegistry = DeferredRegister.create((IForgeRegistry)ForgeRegistries.FEATURES, (String)"geolosys");
    public final DeferredRegister<CreativeModeTab> TabRegistry = DeferredRegister.create((ResourceKey)Registries.f_279569_, (String)"geolosys");
    public final RegistryObject<Block> peat = this.BlockRegistry.register("peat", PeatBlock::new);
    public final RegistryObject<Block> rhododendron = this.BlockRegistry.register("rhododendron", () -> new PlantBlock(false, this.peat));
    public RegistryObject<CreativeModeTab> CreativeTab;
    public final RegistryObject<Item> proPick = this.ItemRegistry.register("prospectors_pick", ProPickItem::new);
    private final List<RegistryObject<Block>> NeedItemBlocks = Lists.newArrayList();
    private final HashMap<String, Integer> UniversalMaterials = new HashMap<String, Integer>(){
        {
            this.put("anthracite_coal", 2);
            this.put("autunite", 0);
            this.put("azurite", 0);
            this.put("bauxite", 0);
            this.put("beryl", 7);
            this.put("bituminous_coal", 2);
            this.put("cassiterite", 0);
            this.put("cinnabar", 0);
            this.put("coal", 2);
            this.put("galena", 0);
            this.put("gold", 0);
            this.put("hematite", 0);
            this.put("kimberlite", 7);
            this.put("lapis", 5);
            this.put("lignite", 2);
            this.put("limonite", 0);
            this.put("malachite", 0);
            this.put("platinum", 0);
            this.put("quartz", 5);
            this.put("sphalerite", 0);
            this.put("teallite", 0);
        }
    };

    public Registry() {
        this.RegisterBlocks();
        this.RegisterItems();
        this.RegisterWorldGen();
        this.RegisterCreativeTab();
    }

    public void RegisterAll(FMLJavaModLoadingContext ctx) {
        this.BlockRegistry.register(ctx.getModEventBus());
        this.ItemRegistry.register(ctx.getModEventBus());
        this.FeatureRegistry.register(ctx.getModEventBus());
        this.TabRegistry.register(ctx.getModEventBus());
    }

    private void RegisterBlocks() {
        BlockBehaviour.Properties baseProps = BlockBehaviour.Properties.m_284310_().m_60913_(5.0f, 10.0f).m_60918_(SoundType.f_56742_).m_284180_(MapColor.f_283947_).m_60999_();
        BlockBehaviour.Properties dsProps = BlockBehaviour.Properties.m_284310_().m_60913_(7.5f, 10.0f).m_60918_(SoundType.f_154677_).m_284180_(MapColor.f_283875_).m_60999_();
        BlockBehaviour.Properties netherProps = BlockBehaviour.Properties.m_284310_().m_60913_(7.5f, 10.0f).m_60918_(SoundType.f_56742_).m_284180_(MapColor.f_283820_).m_60999_();
        this.NeedItemBlocks.add(this.peat);
        this.NeedItemBlocks.add(this.rhododendron);
        this.NeedItemBlocks.add((RegistryObject<Block>)this.BlockRegistry.register("ancient_debris_ore", () -> new OreBlock(netherProps.m_60918_(SoundType.f_56726_), 0)));
        this.NeedItemBlocks.add((RegistryObject<Block>)this.BlockRegistry.register("ancient_debris_ore_sample", SampleBlock::new));
        this.NeedItemBlocks.add((RegistryObject<Block>)this.BlockRegistry.register("nether_gold_ore", () -> new OreBlock(netherProps.m_60918_(SoundType.f_56729_), 1)));
        this.NeedItemBlocks.add((RegistryObject<Block>)this.BlockRegistry.register("nether_gold_ore_sample", SampleBlock::new));
        this.UniversalMaterials.forEach((name, xp) -> {
            this.NeedItemBlocks.add((RegistryObject<Block>)this.BlockRegistry.register(name + "_ore", () -> new OreBlock(baseProps, (int)xp)));
            this.NeedItemBlocks.add((RegistryObject<Block>)this.BlockRegistry.register("deepslate_" + name + "_ore", () -> new OreBlock(dsProps, (int)xp)));
            this.NeedItemBlocks.add((RegistryObject<Block>)this.BlockRegistry.register(name + "_ore_sample", SampleBlock::new));
        });
    }

    private void RegisterItems() {
        Item.Properties baseProps = new Item.Properties();
        this.NeedItemBlocks.forEach(x -> this.ItemRegistry.register(x.getId().m_135815_(), () -> new BlockItem((Block)x.get(), new Item.Properties())));
        this.ItemRegistry.register("anthracite_coal", () -> new FuelItem(20));
        this.ItemRegistry.register("bituminous_coal", () -> new FuelItem(16));
        this.ItemRegistry.register("lignite_coal", () -> new FuelItem(12));
        this.ItemRegistry.register("peat_coal", () -> new FuelItem(6));
        this.ItemRegistry.register("bituminous_coal_coke", () -> new FuelItem(32));
        this.ItemRegistry.register("lignite_coal_coke", () -> new FuelItem(24));
        this.ItemRegistry.register("aluminum_ingot", () -> new Item(baseProps));
        this.ItemRegistry.register("lead_ingot", () -> new Item(baseProps));
        this.ItemRegistry.register("nickel_ingot", () -> new Item(baseProps));
        this.ItemRegistry.register("platinum_ingot", () -> new Item(baseProps));
        this.ItemRegistry.register("silver_ingot", () -> new Item(baseProps));
        this.ItemRegistry.register("tin_ingot", () -> new Item(baseProps));
        this.ItemRegistry.register("zinc_ingot", () -> new Item(baseProps));
        this.ItemRegistry.register("aluminum_nugget", () -> new Item(baseProps));
        this.ItemRegistry.register("copper_nugget", () -> new Item(baseProps));
        this.ItemRegistry.register("lead_nugget", () -> new Item(baseProps));
        this.ItemRegistry.register("nickel_nugget", () -> new Item(baseProps));
        this.ItemRegistry.register("platinum_nugget", () -> new Item(baseProps));
        this.ItemRegistry.register("silver_nugget", () -> new Item(baseProps));
        this.ItemRegistry.register("tin_nugget", () -> new Item(baseProps));
        this.ItemRegistry.register("zinc_nugget", () -> new Item(baseProps));
        this.ItemRegistry.register("aluminum_cluster", () -> new Item(baseProps));
        this.ItemRegistry.register("ancient_debris_cluster", () -> new Item(baseProps));
        this.ItemRegistry.register("copper_cluster", () -> new Item(baseProps));
        this.ItemRegistry.register("gold_cluster", () -> new Item(baseProps));
        this.ItemRegistry.register("iron_cluster", () -> new Item(baseProps));
        this.ItemRegistry.register("lead_cluster", () -> new Item(baseProps));
        this.ItemRegistry.register("nether_gold_cluster", () -> new Item(baseProps));
        this.ItemRegistry.register("nickel_cluster", () -> new Item(baseProps));
        this.ItemRegistry.register("osmium_cluster", () -> new Item(baseProps));
        this.ItemRegistry.register("platinum_cluster", () -> new Item(baseProps));
        this.ItemRegistry.register("silver_cluster", () -> new Item(baseProps));
        this.ItemRegistry.register("tin_cluster", () -> new Item(baseProps));
        this.ItemRegistry.register("uranium_cluster", () -> new Item(baseProps));
        this.ItemRegistry.register("zinc_cluster", () -> new Item(baseProps));
    }

    public void RegisterWorldGen() {
        this.FeatureRegistry.register("deposits", () -> new DepositFeature((Codec<NoneFeatureConfiguration>)NoneFeatureConfiguration.f_67815_));
        this.FeatureRegistry.register("remove_veins", () -> new RemoveVeinsFeature((Codec<NoneFeatureConfiguration>)NoneFeatureConfiguration.f_67815_));
    }

    public void RegisterCreativeTab() {
        this.CreativeTab = this.TabRegistry.register("items", () -> CreativeModeTab.builder().m_257737_(() -> new ItemStack((ItemLike)this.proPick.get())).m_257941_((Component)Component.m_237115_((String)"itemGroup.geolosys.name")).m_257501_((params, output) -> {
            Stream<ResourceLocation> items = ForgeRegistries.ITEMS.getKeys().stream().filter(x -> x.m_135827_().equals("geolosys"));
            items.sorted((a, b) -> {
                Item x = (Item)ForgeRegistries.ITEMS.getValue(a);
                Item y = (Item)ForgeRegistries.ITEMS.getValue(b);
                if (x != null && y != null) {
                    return x.getClass().toString().compareTo(y.getClass().toString());
                }
                return a.compareTo(b);
            }).forEach(key -> {
                Item item = (Item)ForgeRegistries.ITEMS.getValue(key);
                if (item != null) {
                    output.m_246342_(new ItemStack((ItemLike)item));
                }
            });
        }).m_257652_());
    }
}

