/*
 * Decompiled with CFR 0.152.
 */
package com.oitsjustjose.geolosys.common.data;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.oitsjustjose.geolosys.Geolosys;
import com.oitsjustjose.geolosys.api.GeolosysAPI;
import com.oitsjustjose.geolosys.api.world.deposit.DenseDeposit;
import com.oitsjustjose.geolosys.api.world.deposit.DikeDeposit;
import com.oitsjustjose.geolosys.api.world.deposit.LayerDeposit;
import com.oitsjustjose.geolosys.api.world.deposit.SparseDeposit;
import com.oitsjustjose.geolosys.api.world.deposit.TopLayerDeposit;
import com.oitsjustjose.geolosys.common.data.serializer.DenseDepositSerializer;
import com.oitsjustjose.geolosys.common.data.serializer.DikeDepositSerializer;
import com.oitsjustjose.geolosys.common.data.serializer.LayerDepositSerializer;
import com.oitsjustjose.geolosys.common.data.serializer.SparseDepositSerializer;
import com.oitsjustjose.geolosys.common.data.serializer.TopLayerDepositSerializer;
import com.oitsjustjose.geolosys.common.utils.Prospecting;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import org.jetbrains.annotations.NotNull;

public class WorldGenDataLoader
extends SimpleJsonResourceReloadListener {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private final DenseDepositSerializer DenseSerializer = new DenseDepositSerializer();
    private final LayerDepositSerializer LayerSerializer = new LayerDepositSerializer();
    private final TopLayerDepositSerializer TopLayerSerializer = new TopLayerDepositSerializer();
    private final DikeDepositSerializer DikeSerializer = new DikeDepositSerializer();
    private final SparseDepositSerializer SparseSerializer = new SparseDepositSerializer();

    public WorldGenDataLoader() {
        super(GSON, "deposits");
    }

    protected void apply(Map<ResourceLocation, JsonElement> datamap, @Nonnull ResourceManager manager, @NotNull ProfilerFiller profiler) {
        GeolosysAPI.plutonRegistry.clear();
        datamap.forEach((rl, json) -> {
            try {
                JsonObject jsonobject = json.getAsJsonObject();
                JsonObject config = jsonobject.get("config").getAsJsonObject();
                Geolosys.getInstance().LOGGER.info("Preparing to load deposit datafile {}", (Object)rl.toString());
                switch (jsonobject.get("type").getAsString()) {
                    case "geolosys:deposit_dense": {
                        DenseDeposit denseDeposit = this.DenseSerializer.deserialize(config);
                        if (denseDeposit != null) {
                            Geolosys.getInstance().LOGGER.info(denseDeposit.toString());
                            GeolosysAPI.plutonRegistry.addDeposit(denseDeposit);
                        }
                        break;
                    }
                    case "geolosys:deposit_layer": {
                        LayerDeposit layerDeposit = this.LayerSerializer.deserialize(config);
                        if (layerDeposit != null) {
                            Geolosys.getInstance().LOGGER.info(layerDeposit.toString());
                            GeolosysAPI.plutonRegistry.addDeposit(layerDeposit);
                        }
                        break;
                    }
                    case "geolosys:deposit_top_layer": {
                        TopLayerDeposit topLayerDeposit = this.TopLayerSerializer.deserialize(config);
                        if (topLayerDeposit != null) {
                            Geolosys.getInstance().LOGGER.info(topLayerDeposit.toString());
                            GeolosysAPI.plutonRegistry.addDeposit(topLayerDeposit);
                        }
                        break;
                    }
                    case "geolosys:deposit_dike": {
                        DikeDeposit dikeDeposit = this.DikeSerializer.deserialize(config);
                        if (dikeDeposit != null) {
                            Geolosys.getInstance().LOGGER.info(dikeDeposit.toString());
                            GeolosysAPI.plutonRegistry.addDeposit(dikeDeposit);
                        }
                        break;
                    }
                    case "geolosys:deposit_sparse": {
                        SparseDeposit sparseDeposit = this.SparseSerializer.deserialize(config);
                        if (sparseDeposit != null) {
                            Geolosys.getInstance().LOGGER.info(sparseDeposit.toString());
                            GeolosysAPI.plutonRegistry.addDeposit(sparseDeposit);
                        }
                        break;
                    }
                    default: {
                        Geolosys.getInstance().LOGGER.warn("Unknown JSON type. Received JSON {}", (Object)json.toString());
                    }
                }
            }
            catch (NullPointerException ex) {
                Geolosys.getInstance().LOGGER.info("Skipping registration of ore {}", rl);
            }
        });
        Prospecting.populateDepositBlocks();
    }
}

