/*
 * Decompiled with CFR 0.152.
 */
package com.oitsjustjose.geolosys.common.utils;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.registries.ForgeRegistries;

public class Utils {
    public static ItemStack blockStateToStack(BlockState state) {
        return new ItemStack((ItemLike)state.m_60734_().m_5456_(), 1);
    }

    public static boolean doStatesMatch(BlockState state1, BlockState state2) {
        return Utils.getRegistryName(state1).equals(Utils.getRegistryName(state2));
    }

    public static String getRegistryName(Block block) {
        return Objects.requireNonNull(ForgeRegistries.BLOCKS.getKey((Object)block)).toString();
    }

    public static String getRegistryName(BlockState state) {
        return Utils.getRegistryName(state.m_60734_());
    }

    public static BlockPos getTopSolidBlock(LevelReader level, BlockPos start) {
        BlockPos retPos = new BlockPos(start.m_123341_(), level.m_141928_() - 1, start.m_123343_());
        while (retPos.m_123342_() > 0 && !level.m_8055_(retPos).m_60804_((BlockGetter)level, retPos)) {
            retPos = retPos.m_7495_();
        }
        return retPos;
    }

    public static MutableComponent tryTranslate(String transKey, Object ... values) {
        try {
            TranslatableContents contents = new TranslatableContents(transKey, "Failed to translate in Utils#tryTranslate", values);
            return contents.m_213698_(null, null, 0);
        }
        catch (CommandSyntaxException ex) {
            return Component.m_237119_().m_130946_(transKey);
        }
    }
}

