/*
 * Decompiled with CFR 0.152.
 */
package com.oitsjustjose.geolosys.common.world.feature;

import com.mojang.serialization.Codec;
import com.oitsjustjose.geolosys.Geolosys;
import com.oitsjustjose.geolosys.api.GeolosysAPI;
import com.oitsjustjose.geolosys.api.world.IDeposit;
import com.oitsjustjose.geolosys.capability.deposit.DepositCapability;
import com.oitsjustjose.geolosys.capability.deposit.IDepositCapability;
import com.oitsjustjose.geolosys.capability.world.ChunkGennedCapability;
import com.oitsjustjose.geolosys.capability.world.IChunkGennedCapability;
import com.oitsjustjose.geolosys.common.config.CommonConfig;
import com.oitsjustjose.geolosys.common.world.feature.FeatureUtils;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.levelgen.FlatLevelSource;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;

public class DepositFeature
extends Feature<NoneFeatureConfiguration> {
    public DepositFeature(Codec<NoneFeatureConfiguration> p_i231976_1_) {
        super(p_i231976_1_);
    }

    @ParametersAreNonnullByDefault
    public boolean m_142674_(FeaturePlaceContext<NoneFeatureConfiguration> f) {
        if (f.m_159775_() instanceof FlatLevelSource) {
            return false;
        }
        WorldGenLevel level = f.m_159774_();
        BlockPos pos = f.m_159777_();
        IDepositCapability depCap = (IDepositCapability)level.m_6018_().getCapability(DepositCapability.CAPABILITY).orElseThrow(() -> new RuntimeException("Geolosys Pluton Capability Is Null.."));
        IChunkGennedCapability cgCap = (IChunkGennedCapability)level.m_6018_().getCapability(ChunkGennedCapability.CAPABILITY).orElseThrow(() -> new RuntimeException("Geolosys Pluton Capability Is Null.."));
        boolean placedPluton = false;
        boolean placedPending = this.placePendingBlocks(level, depCap, cgCap, pos);
        if (level.m_213780_().m_188500_() > (Double)CommonConfig.CHUNK_SKIP_CHANCE.get()) {
            for (int p = 0; p < (Integer)CommonConfig.NUMBER_PLUTONS_PER_CHUNK.get(); ++p) {
                boolean anyGenerated;
                IDeposit pluton = GeolosysAPI.plutonRegistry.pick(level, pos);
                if (pluton == null) continue;
                boolean bl = anyGenerated = pluton.generate(level, pos, depCap, cgCap) > 0;
                if (!anyGenerated) continue;
                placedPluton = true;
                pluton.afterGen(level, pos, depCap, cgCap);
            }
        }
        cgCap.setChunkGenerated(new ChunkPos(pos));
        return placedPluton || placedPending;
    }

    private boolean placePendingBlocks(WorldGenLevel level, IDepositCapability depCap, IChunkGennedCapability cgCap, BlockPos origin) {
        ChunkPos cp = new ChunkPos(origin);
        ConcurrentLinkedQueue<DepositCapability.PendingBlock> q = depCap.getPendingBlocks(cp);
        if (cgCap.hasChunkGenerated(cp) && !q.isEmpty()) {
            Geolosys.getInstance().LOGGER.info("Chunk [{}, {}] has already generated but we're trying to place pending blocks anyways", (Object)cp.f_45578_, (Object)cp.f_45579_);
        }
        q.forEach(x -> FeatureUtils.enqueueBlockPlacement(level, cp, x.pos(), x.state(), depCap, cgCap));
        depCap.removePendingBlocksForChunk(cp);
        return !q.isEmpty();
    }
}

