/*
 * Decompiled with CFR 0.152.
 */
package com.oitsjustjose.geolosys.common.world.feature;

import com.oitsjustjose.geolosys.Geolosys;
import com.oitsjustjose.geolosys.capability.deposit.IDepositCapability;
import com.oitsjustjose.geolosys.capability.world.IChunkGennedCapability;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkAccess;

public class FeatureUtils {
    private static boolean ensureCanWriteNoThrow(WorldGenLevel level, BlockPos pos) {
        if (level instanceof WorldGenRegion) {
            WorldGenRegion region = (WorldGenRegion)level;
            ChunkPos center = region.m_143488_();
            int i = SectionPos.m_123171_((int)pos.m_123341_());
            int j = SectionPos.m_123171_((int)pos.m_123343_());
            int k = Math.abs(center.f_45578_ - i);
            int l = Math.abs(center.f_45579_ - j);
            return k <= 1 && l <= 1;
        }
        Geolosys.getInstance().LOGGER.error("level was not WorldGenRegion");
        return false;
    }

    public static boolean enqueueBlockPlacement(WorldGenLevel level, ChunkPos chunk, BlockPos pos, BlockState state, IDepositCapability depCap, @Nullable IChunkGennedCapability cgCap) {
        if (cgCap != null && cgCap.hasChunkGenerated(new ChunkPos(pos))) {
            if (!level.m_7232_(chunk.f_45578_, chunk.f_45579_)) {
                return false;
            }
            if (!FeatureUtils.ensureCanWriteNoThrow(level, pos)) {
                return false;
            }
            ChunkAccess chunkaccess = level.m_46865_(pos);
            BlockState blockstate = chunkaccess.m_6978_(pos, state, false);
            if (blockstate != null) {
                level.m_6018_().m_6559_(pos, blockstate, state);
            }
            return true;
        }
        if (!FeatureUtils.ensureCanWriteNoThrow(level, pos)) {
            depCap.putPendingBlock(pos, state);
            return false;
        }
        if (!level.m_7731_(pos, state, 18)) {
            depCap.putPendingBlock(pos, state);
            return false;
        }
        return true;
    }

    public static void fixSnowyBlock(WorldGenLevel level, BlockPos posPlaced) {
        BlockState below = level.m_8055_(posPlaced.m_7495_());
        if (below.m_61138_((Property)BlockStateProperties.f_61451_)) {
            level.m_7731_(posPlaced.m_7495_(), (BlockState)below.m_61124_((Property)BlockStateProperties.f_61451_, (Comparable)Boolean.valueOf(false)), 18);
        }
    }
}

