/*
 * Decompiled with CFR 0.152.
 */
package wildCaves;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Icon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import wildCaves.WildCaves;

public abstract class BlockStalactite
extends Block {
    private final int numOfStructures;
    @SideOnly(value=Side.CLIENT)
    private Icon[] iconArray;

    public BlockStalactite(int id, int num) {
        super(id, Material.field_76246_e);
        this.numOfStructures = num;
        this.func_71848_c(0.8f);
        this.func_71849_a(WildCaves.tabWildCaves);
    }

    public boolean func_71854_d(World world, int x, int y, int z) {
        boolean result = false;
        int metadata = world.func_72805_g(x, y, z);
        if (metadata != 0 && metadata < 4 || metadata == 7 || metadata == 11) {
            result = this.connected(world, x, y, z, true);
        } else if (metadata == 6 || metadata > 7 && metadata < 11 || metadata == 12) {
            result = this.connected(world, x, y, z, false);
        } else if (metadata == 0 || metadata == 4 || metadata == 5) {
            result = this.connected(world, x, y, z, true) || this.connected(world, x, y, z, false);
        }
        return result;
    }

    public boolean canSilkHarvest(World world, EntityPlayer player, int x, int y, int z, int metadata) {
        return true;
    }

    public boolean connected(World world, int x, int y, int z, boolean searchUp) {
        int increment = searchUp ? 1 : -1;
        int i = increment;
        while (world.func_72798_a(x, y + i, z) == WildCaves.blockStoneStalactite.field_71990_ca || world.func_72798_a(x, y + i, z) == WildCaves.blockSandStalactite.field_71990_ca) {
            i += increment;
        }
        return world.func_72809_s(x, y + i, z);
    }

    public AxisAlignedBB func_71872_e(World par1World, int par2, int par3, int par4) {
        if (WildCaves.solidStalactites) {
            return super.func_71872_e(par1World, par2, par3, par4);
        }
        return null;
    }

    public int func_71873_h(World world, int x, int y, int z) {
        return world.func_72805_g(x, y, z);
    }

    @SideOnly(value=Side.CLIENT)
    public Icon func_71858_a(int side, int metadata) {
        if (metadata >= this.numOfStructures) {
            metadata = this.numOfStructures - 1;
        }
        return this.iconArray[metadata];
    }

    public int func_71857_b() {
        return 1;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_71879_a(int par1, CreativeTabs par2CreativeTabs, List par3List) {
        for (int i = 0; i < this.numOfStructures; ++i) {
            par3List.add(new ItemStack(par1, 1, i));
        }
    }

    public boolean func_71926_d() {
        return false;
    }

    public void func_71860_a(World world, int x, int y, int z, EntityLivingBase par5EntityLivingBase, ItemStack par6ItemStack) {
        this.func_71861_g(world, x, y, z);
    }

    public void func_71861_g(World world, int x, int y, int z) {
        if (!world.field_72995_K && !this.func_71854_d(world, x, y, z)) {
            this.func_71929_a(world, x, y, z, new ItemStack(this.field_71990_ca, 1, world.func_72805_g(x, y, z)));
            world.func_94571_i(x, y, z);
        }
    }

    public void func_71869_a(World world, int x, int y, int z, Entity entity) {
        entity.field_70159_w *= 0.7;
        entity.field_70179_y *= 0.7;
    }

    public void func_71866_a(World world, int par2, int par3, int par4, Entity entity, float par6) {
        if (WildCaves.damageWhenFallenOn && entity.func_70089_S()) {
            entity.func_70097_a(DamageSource.field_76377_j, 5.0f);
        }
    }

    public void func_71863_a(World world, int x, int y, int z, int blockID) {
        if (!world.field_72995_K && !this.func_71854_d(world, x, y, z)) {
            world.func_94578_a(x, y, z, true);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94332_a(IconRegister iconRegister) {
        this.iconArray = new Icon[this.numOfStructures];
        for (int i = 0; i < this.iconArray.length; ++i) {
            this.iconArray[i] = iconRegister.func_94245_a("wildcaves3" + this.func_111023_E() + i);
        }
    }

    public boolean func_71886_c() {
        return false;
    }

    public void func_71902_a(IBlockAccess par1IBlockAccess, int par2, int par3, int par4) {
        int metadata = par1IBlockAccess.func_72805_g(par2, par3, par4);
        switch (metadata) {
            case 1: {
                this.func_71905_a(0.25f, 0.2f, 0.25f, 0.75f, 1.0f, 0.75f);
                break;
            }
            case 2: {
                this.func_71905_a(0.25f, 0.5f, 0.25f, 0.75f, 1.0f, 0.75f);
                break;
            }
            case 9: {
                this.func_71905_a(0.25f, 0.0f, 0.25f, 0.75f, 0.8f, 0.75f);
                break;
            }
            case 10: {
                this.func_71905_a(0.25f, 0.0f, 0.25f, 0.75f, 0.4f, 0.75f);
                break;
            }
            default: {
                this.func_71905_a(0.25f, 0.0f, 0.25f, 0.75f, 1.0f, 0.75f);
            }
        }
    }
}

