/*
 * Decompiled with CFR 0.152.
 */
package wildCaves;

import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.IWorldGenerator;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.network.NetworkMod;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.logging.Level;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.WeightedRandomChestContent;
import net.minecraftforge.common.ChestGenHooks;
import net.minecraftforge.common.Configuration;
import wildCaves.BlockDecorations;
import wildCaves.BlockFlora;
import wildCaves.BlockFossils;
import wildCaves.BlockSandstoneStalactite;
import wildCaves.BlockStoneStalactite;
import wildCaves.EventManager;
import wildCaves.ItemDecoration;
import wildCaves.ItemFlora;
import wildCaves.ItemFossil;
import wildCaves.ItemSandstoneStalactite;
import wildCaves.ItemStoneStalactite;
import wildCaves.WorldGenWildCaves;

@Mod(modid="wildcaves3", name="Wild Caves 3", version="0.4.3.5")
@NetworkMod(clientSideRequired=true)
public class WildCaves {
    public static final String modid = "wildcaves3";
    public static Block blockFlora;
    public static Block blockDecorations;
    public static Block blockFossils;
    public static BlockStoneStalactite blockStoneStalactite;
    public static BlockSandstoneStalactite blockSandStalactite;
    public static int floraLightLevel;
    private static int blockStoneStalactiteID;
    private static int blockSandStalactiteID;
    private static int blockFloraID;
    public static int timesPerChunck;
    private static int blockDecorationsID;
    private static int blockFossilsID;
    public static int chanceForNodeToSpawn;
    public static boolean solidStalactites;
    public static boolean damageWhenFallenOn;
    public static Configuration config;
    private EventManager eventmanager;
    public static CreativeTabs tabWildCaves;

    public void initBlocks() {
        if (blockStoneStalactiteID > 0) {
            blockStoneStalactite = new BlockStoneStalactite(blockStoneStalactiteID);
            GameRegistry.registerBlock((Block)blockStoneStalactite, ItemStoneStalactite.class, (String)"StoneStalactite");
        }
        if (blockSandStalactiteID > 0) {
            blockSandStalactite = new BlockSandstoneStalactite(blockSandStalactiteID);
            GameRegistry.registerBlock((Block)blockSandStalactite, ItemSandstoneStalactite.class, (String)"SandstoneSalactite");
        }
        if (blockDecorationsID > 0) {
            blockDecorations = new BlockDecorations(blockDecorationsID);
            GameRegistry.registerBlock((Block)blockDecorations, ItemDecoration.class, (String)"Decorations");
        }
        if (blockFloraID > 0) {
            blockFlora = new BlockFlora(blockFloraID).func_71900_a(floraLightLevel / 15);
            GameRegistry.registerBlock((Block)blockFlora, ItemFlora.class, (String)"Flora");
        }
        if (blockFossilsID > 0) {
            blockFossils = new BlockFossils(blockFossilsID);
            GameRegistry.registerBlock((Block)blockFossils, ItemFossil.class, (String)"FossilBlock");
        }
    }

    @Mod.EventHandler
    public void load(FMLInitializationEvent event) {
        this.initBlocks();
        WorldGenWildCaves gen = new WorldGenWildCaves(config);
        if (WorldGenWildCaves.maxLength > 0) {
            GameRegistry.registerWorldGenerator((IWorldGenerator)gen);
        }
        for (String txt : new String[]{"DUNGEON_CHEST", "MINESHAFT_CORRIDOR", "STRONGHOLD_CORRIDOR"}) {
            for (int i = 0; i < 5; ++i) {
                if (i == 1) continue;
                ChestGenHooks.getInfo((String)txt).addItem(new WeightedRandomChestContent(new ItemStack(Item.field_82799_bQ.field_77779_bT, 1, i), 1, 2, 50));
            }
        }
        if (blockFossilsID > 0) {
            this.eventmanager = new EventManager(chanceForNodeToSpawn);
            GameRegistry.registerWorldGenerator((IWorldGenerator)this.eventmanager);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        config = new Configuration(event.getSuggestedConfigurationFile());
        try {
            config.load();
            blockStoneStalactiteID = config.getBlock("Stalactite ID", 600).getInt(600);
            blockSandStalactiteID = config.getBlock("Sandstone Stalactite ID", 601).getInt(601);
            blockFloraID = config.getBlock("Flora ID", 602).getInt(602);
            blockDecorationsID = config.getBlock("Decorations ID", 603).getInt(603);
            blockFossilsID = config.getBlock("Fossils ID", 604).getInt(604);
            solidStalactites = config.get("general", "Solid stalactites/stalgmites", false).getBoolean(false);
            damageWhenFallenOn = config.get("general", "Stalgmites damage entities when fallen on", false).getBoolean(false);
            floraLightLevel = config.get("general", "Flora light level", 5).getInt(5);
            if (floraLightLevel > 15) {
                floraLightLevel = 15;
            }
            chanceForNodeToSpawn = config.get("general", "Chance for a fossil node to generate", 5).getInt(5);
        }
        catch (Exception e) {
            FMLLog.log((Level)Level.SEVERE, (Throwable)e, (String)"WildCaves3 had a problem loading it's configuration", (Object[])new Object[0]);
        }
        finally {
            config.save();
        }
    }

    static {
        tabWildCaves = new CreativeTabs("WildCaves3"){

            public ItemStack getIconItemStack() {
                return new ItemStack(Item.field_77748_bA, 1, 0);
            }
        };
    }
}

