/*
 * Decompiled with CFR 0.152.
 */
package wildCaves;

import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.IWorldGenerator;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.logging.Level;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraftforge.common.Configuration;
import wildCaves.generation.biomeGen.GenerationArid;
import wildCaves.generation.biomeGen.GenerationFrozen;
import wildCaves.generation.biomeGen.GenerationHumid;
import wildCaves.generation.biomeGen.GenerationJungle;
import wildCaves.generation.biomeGen.GenerationNormal;

public class WorldGenWildCaves
implements IWorldGenerator {
    private static boolean stalactites;
    private static boolean sandstoneStalactites;
    private static boolean Flora;
    public static float probabilityVinesJungle;
    public static float probabilityVines;
    public static float probabilityIcicle;
    public static float probabilityWet;
    public static float probabilityDry;
    public static float probabilityGlowcapsHumid;
    public static float probabilityGlowcaps;
    public static float probabilityIceshrooms;
    public static float probabilityStalactite;
    public static float probabilitySpiderWeb;
    public static float probabilitySandStalactites;
    public static float probabilitySkulls;
    public static int maxGenHeight;
    public static int maxLength;
    private static int timesPerChunck;
    public static int maxGenHeightGlowcapNormal;
    private static List<Integer> dimensionBlacklist;
    private static List<Integer> blockWhiteList;
    private static final GenerationJungle jungleGen;
    private static final GenerationHumid wetGen;
    private static final GenerationArid aridGen;
    private static final GenerationNormal normalGen;
    private static final GenerationFrozen frozenGen;

    public WorldGenWildCaves(Configuration config) {
        WorldGenWildCaves.setConfig(config);
    }

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkProvider chunkGenerator, IChunkProvider chunkProvider) {
        int blockX = chunkX * 16;
        int blockZ = chunkZ * 16;
        if (!dimensionBlacklist.contains(world.field_73011_w.field_76574_g)) {
            for (int i = 0; i < timesPerChunck; ++i) {
                int Ycoord;
                int Xcoord = blockX + random.nextInt(16);
                int Zcoord = blockZ + random.nextInt(16);
                for (Ycoord = random.nextInt(maxGenHeight); !(blockWhiteList.contains(world.func_72798_a(Xcoord, Ycoord + 1, Zcoord)) && world.func_72799_c(Xcoord, Ycoord, Zcoord) || Ycoord <= 10); --Ycoord) {
                }
                if (Ycoord <= 10) continue;
                BiomeGenBase biome = world.func_72807_a(blockX, blockZ);
                if (biome.field_76750_F <= 0.1f) {
                    frozenGen.func_76484_a(world, random, Xcoord, Ycoord, Zcoord);
                    continue;
                }
                if (biome.field_76750_F > 1.5f && biome.field_76751_G < 0.1f) {
                    aridGen.func_76484_a(world, random, Xcoord, Ycoord, Zcoord);
                    continue;
                }
                if (biome.func_76736_e() && biome.field_76750_F > 1.0f) {
                    jungleGen.func_76484_a(world, random, Xcoord, Ycoord, Zcoord);
                    continue;
                }
                if (biome.func_76736_e() || biome == BiomeGenBase.field_76771_b || biome == BiomeGenBase.field_76781_i) {
                    wetGen.func_76484_a(world, random, Xcoord, Ycoord, Zcoord);
                    continue;
                }
                normalGen.func_76484_a(world, random, Xcoord, Ycoord, Zcoord);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setConfig(Configuration config) {
        try {
            String[] list;
            config.load();
            sandstoneStalactites = config.get("Permissions", "Generate Sandstone stalactites on arid biomes", true).getBoolean(true);
            Flora = config.get("Permissions", "Generate flora on caves", true).getBoolean(true);
            stalactites = config.get("Permissions", "Generate stalactites on caves", true).getBoolean(true);
            for (String txt : list = config.get("Permissions", "Dimension Blacklist", "-1,1").getString().split(",")) {
                try {
                    dimensionBlacklist.add(Integer.parseInt(txt.trim()));
                }
                catch (NumberFormatException n) {
                    // empty catch block
                }
            }
            for (String txt : list = config.get("Permissions", "Block white list", "1,2,3,4,13,14,15,16,21,24,56,73,74,79,80,82,97,129").getString().split(",")) {
                try {
                    blockWhiteList.add(Integer.parseInt(txt.trim()));
                }
                catch (NumberFormatException n) {
                    // empty catch block
                }
            }
            probabilityVinesJungle = (float)config.get("Biome specific", "Probability of vines on jungle caves", 0.5).getDouble(0.5);
            probabilityIcicle = (float)config.get("Biome specific", "Probability of iciles on frozen caves", 0.6).getDouble(0.6);
            probabilityWet = (float)config.get("Biome specific", "Probability of more water fountains on wet caves", 0.1).getDouble(0.1);
            probabilityDry = (float)config.get("Biome specific", "Probability of less generation arid caves", 0.5).getDouble(0.5);
            probabilityGlowcapsHumid = (float)config.get("Biome specific", "Probability of Glowing mushrooms on humid/jungle caves", 0.3).getDouble(0.3);
            probabilityIceshrooms = (float)config.get("Biome specific", "Probability of Glowing Ice mushrooms on frozen caves", 0.3).getDouble(0.3);
            probabilitySandStalactites = (float)config.get("Biome specific", "Probability of sandstone stalactites on arid caves", 0.5).getDouble(0.5);
            probabilityVines = (float)config.get("Non biome specific", "Probability of vines on caves", 0.1).getDouble(0.1);
            probabilityGlowcaps = (float)config.get("Non biome specific", "Probability of glowing mushrooms on caves", 0.1).getDouble(0.1);
            probabilityStalactite = (float)config.get("Non biome specific", "Probability of Stalactites/stalagmites", 0.5).getDouble(0.5);
            probabilitySpiderWeb = (float)config.get("Non biome specific", "Probability of spider webs", 0.15).getDouble(0.15);
            maxGenHeightGlowcapNormal = config.get("Non biome specific", "Max height at wich to generate glowcaps on normal biomes", 30).getInt();
            probabilitySkulls = (float)config.get("Non biome specific", "Probability of skulls", 1.0E-4).getDouble(1.0E-4);
            timesPerChunck = config.get("general", "times to attemp generating per chunk", 40).getInt();
            maxGenHeight = config.get("general", "Max height at which to generate", 80).getInt();
            maxLength = config.get("general", "Max length of structure generation", 8).getInt();
        }
        catch (Exception e) {
            FMLLog.log((Level)Level.SEVERE, (Throwable)e, (String)"WildCaves3 has a problem loading it's configuration", (Object[])new Object[0]);
        }
        finally {
            config.save();
        }
    }

    static {
        timesPerChunck = 50;
        dimensionBlacklist = new ArrayList<Integer>();
        blockWhiteList = new ArrayList<Integer>();
        jungleGen = new GenerationJungle();
        wetGen = new GenerationHumid();
        aridGen = new GenerationArid();
        normalGen = new GenerationNormal();
        frozenGen = new GenerationFrozen();
    }
}

