/*
 * Decompiled with CFR 0.152.
 */
package wildCaves;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.util.Random;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenMinable;
import net.minecraftforge.event.terraingen.OreGenEvent;
import wildCaves.WildCaves;
import wildCaves.WorldGenWildCaves;

public class EventManager {
    private final WorldGenMinable[] mines = new WorldGenMinable[]{new WorldGenMinable(WildCaves.blockFossils, 4), new WorldGenMinable(WildCaves.blockFossils, 5), new WorldGenMinable(WildCaves.blockFossils, 6)};
    private final int chanceForNodeToSpawn;

    public EventManager(int chanceForNodeToSpawn) {
        this.chanceForNodeToSpawn = chanceForNodeToSpawn;
    }

    @SubscribeEvent
    public void generate(OreGenEvent.Post oreGen) {
        if (!WorldGenWildCaves.dimensionBlacklist.contains(oreGen.world.field_73011_w.field_76574_g)) {
            this.addOreSpawn(this.mines[oreGen.rand.nextInt(3)], oreGen.world, oreGen.rand, oreGen.worldX, oreGen.worldZ, 16, 16, this.chanceForNodeToSpawn, 1, 90);
        }
    }

    public void addOreSpawn(WorldGenMinable mine, World world, Random random, int blockXPos, int blockZPos, int maxX, int maxZ, int chancesToSpawn, int minY, int maxY) {
        assert (minY > 0 && maxY > 0) : "addOreSpawn: The Minimum Y and Maximum Y must be greater than 0";
        int diffBtwnMinMaxY = maxY - minY;
        if (maxY <= minY) {
            diffBtwnMinMaxY = 1;
        }
        assert (maxX > 0 && maxX <= 16) : "addOreSpawn: The Maximum X must be greater than 0 and less than 16";
        assert (maxZ > 0 && maxZ <= 16) : "addOreSpawn: The Maximum Z must be greater than 0 and less than 16";
        for (int x = 0; x < chancesToSpawn; ++x) {
            int posX = blockXPos + random.nextInt(maxX);
            int posY = minY + random.nextInt(diffBtwnMinMaxY);
            int posZ = blockZPos + random.nextInt(maxZ);
            mine.func_76484_a(world, random, posX, posY, posZ);
        }
    }
}

