/*
 * Decompiled with CFR 0.152.
 */
package wildCaves;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.registry.GameData;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.event.terraingen.DecorateBiomeEvent;
import wildCaves.Utils;
import wildCaves.generation.biomeGen.GenerationArid;
import wildCaves.generation.biomeGen.GenerationFrozen;
import wildCaves.generation.biomeGen.GenerationHumid;
import wildCaves.generation.biomeGen.GenerationJungle;
import wildCaves.generation.biomeGen.GenerationNormal;

public class WorldGenWildCaves {
    public static float probabilityVinesJungle;
    public static float probabilityVines;
    public static float probabilityIcicle;
    public static float probabilityWet;
    public static float probabilityDry;
    public static float probabilityGlowcapsHumid;
    public static float probabilityGlowcaps;
    public static float probabilityIceshrooms;
    public static float probabilityStalactite;
    public static float probabilitySpiderWeb;
    public static float probabilitySandStalactites;
    public static float probabilitySkulls;
    public static int maxGenHeight;
    public static int maxLength;
    private static int timesPerChunck;
    public static int maxGenHeightGlowcapNormal;
    public static List<Integer> dimensionBlacklist;
    private static List<Block> blockWhiteList;
    private static final GenerationJungle jungleGen;
    private static final GenerationHumid wetGen;
    private static final GenerationArid aridGen;
    private static final GenerationNormal normalGen;
    private static final GenerationFrozen frozenGen;

    public WorldGenWildCaves(Configuration config) {
        WorldGenWildCaves.setConfig(config);
    }

    public static boolean isWhiteListed(Block block) {
        return blockWhiteList.contains(block);
    }

    @SubscribeEvent
    public void decorate(DecorateBiomeEvent.Post decorationEvent) {
        this.generate(decorationEvent.rand, decorationEvent.chunkX + 8, decorationEvent.chunkZ + 8, decorationEvent.world);
    }

    public void generate(Random random, int blockX, int blockZ, World world) {
        if (!dimensionBlacklist.contains(world.field_73011_w.field_76574_g)) {
            for (int i = 0; i < timesPerChunck; ++i) {
                int Ycoord;
                int Xcoord = blockX + random.nextInt(16);
                int Zcoord = blockZ + random.nextInt(16);
                for (Ycoord = Math.min(world.func_72976_f(Xcoord, Zcoord) - 1, random.nextInt(maxGenHeight)); !(Ycoord <= 10 || blockWhiteList.contains(world.func_147439_a(Xcoord, Ycoord + 1, Zcoord)) && world.func_147437_c(Xcoord, Ycoord, Zcoord)); --Ycoord) {
                }
                if (Ycoord <= 10) continue;
                BiomeGenBase biome = world.func_72807_a(Xcoord, Zcoord);
                if (BiomeDictionary.isBiomeOfType((BiomeGenBase)biome, (BiomeDictionary.Type)BiomeDictionary.Type.FROZEN)) {
                    frozenGen.func_76484_a(world, random, Xcoord, Ycoord, Zcoord);
                    continue;
                }
                if (biome.field_76750_F > 1.5f && biome.field_76751_G < 0.1f) {
                    aridGen.func_76484_a(world, random, Xcoord, Ycoord, Zcoord);
                    continue;
                }
                if (BiomeDictionary.isBiomeOfType((BiomeGenBase)biome, (BiomeDictionary.Type)BiomeDictionary.Type.JUNGLE)) {
                    jungleGen.func_76484_a(world, random, Xcoord, Ycoord, Zcoord);
                    continue;
                }
                if (biome.func_76736_e() || BiomeDictionary.isBiomeOfType((BiomeGenBase)biome, (BiomeDictionary.Type)BiomeDictionary.Type.WATER)) {
                    wetGen.func_76484_a(world, random, Xcoord, Ycoord, Zcoord);
                    continue;
                }
                normalGen.func_76484_a(world, random, Xcoord, Ycoord, Zcoord);
            }
        }
    }

    private static void setConfig(Configuration config) {
        Block block;
        String[] list;
        String category = "Permissions";
        boolean sandstoneStalactites = config.get(category, "Generate Sandstone stalactites on arid biomes", true).getBoolean(true);
        boolean flora = config.get(category, "Generate flora on caves", true).getBoolean(true);
        boolean stalactites = config.get(category, "Generate stalactites on caves", true).getBoolean(true);
        for (String txt : list = config.get(category, "Dimension Blacklist", "-1,1").getString().split(",")) {
            try {
                dimensionBlacklist.add(Integer.parseInt(txt.trim()));
            }
            catch (NumberFormatException n) {
                // empty catch block
            }
        }
        for (String txt : list = config.get(category, "Block white list", "stone,grass,dirt,cobblestone,gravel,gold_ore,iron_ore,coal_ore,lapis_ore,sandstone,diamond_ore,redstone_ore,lit_redstone_ore,ice,snow,clay,monster_egg,emerald_ore").getString().split(",")) {
            try {
                block = (Block)GameData.blockRegistry.func_82594_a(txt.trim());
                if (block == null || block.func_149688_o() == Material.field_151579_a) continue;
                blockWhiteList.add(block);
            }
            catch (Exception n) {
                // empty catch block
            }
        }
        category = "Biome specific";
        probabilityVinesJungle = (float)config.get(category, "Probability of vines on jungle caves", 0.5).getDouble(0.5);
        probabilityIcicle = (float)config.get(category, "Probability of icicles on frozen caves", 0.6).getDouble(0.6);
        try {
            block = (Block)GameData.blockRegistry.func_82594_a(config.get(category, "Block to generate in frozen caves", "ice").getString().trim());
            if (block != null && block.func_149688_o().func_151565_r() == MapColor.field_151657_g) {
                Utils.frozen = block;
            }
        }
        catch (Exception n) {
            // empty catch block
        }
        probabilityWet = (float)config.get(category, "Probability of more water fountains on wet caves", 0.1).getDouble(0.1);
        probabilityDry = (float)config.get(category, "Probability of less generation arid caves", 0.5).getDouble(0.5);
        probabilityGlowcapsHumid = (float)config.get(category, "Probability of Glowing mushrooms on humid/jungle caves", 0.3).getDouble(0.3);
        probabilityIceshrooms = (float)config.get(category, "Probability of Glowing Ice mushrooms on frozen caves", 0.3).getDouble(0.3);
        probabilitySandStalactites = (float)config.get(category, "Probability of sandstone stalactites on arid caves", 0.5).getDouble(0.5);
        category = "Non biome specific";
        probabilityVines = (float)config.get(category, "Probability of vines on caves", 0.1).getDouble(0.1);
        probabilityGlowcaps = (float)config.get(category, "Probability of glowing mushrooms on caves", 0.1).getDouble(0.1);
        probabilityStalactite = (float)config.get(category, "Probability of Stalactites/stalagmites", 0.5).getDouble(0.5);
        probabilitySpiderWeb = (float)config.get(category, "Probability of spider webs", 0.15).getDouble(0.15);
        maxGenHeightGlowcapNormal = config.get(category, "Max height at which to generate glowcaps on normal biomes", 30).getInt();
        probabilitySkulls = (float)config.get(category, "Probability of skulls", 1.0E-4).getDouble(1.0E-4);
        if (!sandstoneStalactites) {
            probabilitySandStalactites = 0.0f;
        }
        if (!flora) {
            probabilityGlowcaps = 0.0f;
            probabilityVinesJungle = 0.0f;
            probabilityGlowcapsHumid = 0.0f;
            probabilityIceshrooms = 0.0f;
            probabilityVines = 0.0f;
            probabilityGlowcaps = 0.0f;
        }
        if (!stalactites) {
            probabilityStalactite = 0.0f;
            probabilitySandStalactites = 0.0f;
        }
        category = "general";
        timesPerChunck = config.get(category, "times to attempt generating per chunk", 40).getInt();
        maxGenHeight = config.get(category, "Max height at which to generate", 80).getInt();
        maxLength = config.get(category, "Max length of structure generation", 8).getInt();
        if (config.hasChanged()) {
            config.save();
        }
    }

    static {
        timesPerChunck = 50;
        dimensionBlacklist = new ArrayList<Integer>();
        blockWhiteList = new ArrayList<Block>();
        jungleGen = new GenerationJungle();
        wetGen = new GenerationHumid();
        aridGen = new GenerationArid();
        normalGen = new GenerationNormal();
        frozenGen = new GenerationFrozen();
    }
}

