/*
 * Decompiled with CFR 0.152.
 */
package wildCaves;

import java.util.Arrays;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.util.BlockPos;
import net.minecraft.world.World;

public final class Utils {
    public static Block frozen = Blocks.field_150432_aD;
    public static List<Block> freezable = Arrays.asList(Blocks.field_150348_b, Blocks.field_150346_d, Blocks.field_150351_n, Blocks.field_150349_c);
    private static IdentityHashMap<Block, Block> sandEquivalent = new IdentityHashMap(8);

    public static void convertToFrozenType(World world, Random random, BlockPos pos) {
        int height = random.nextInt(5) + 3;
        int length = random.nextInt(5) + 3;
        int width = random.nextInt(5) + 3;
        int newX = pos.func_177958_n() - length / 2;
        int newY = pos.func_177956_o() + height / 2;
        int newZ = pos.func_177952_p() - width / 2;
        for (int i = 0; i < height; ++i) {
            for (int j = 0; j < length; ++j) {
                for (int k = 0; k < width; ++k) {
                    BlockPos newPos;
                    Block aux;
                    if (Utils.weightedChoise(0.8f, 0.2f, 0.0f, 0.0f, 0.0f, 0.0f) != 1 || !freezable.contains(aux = world.func_180495_p(newPos = new BlockPos(newX + j, newY - i, newZ + k)).func_177230_c())) continue;
                    world.func_180501_a(newPos, frozen.func_176223_P(), 2);
                }
            }
        }
    }

    public static void convertToSandType(World world, Random random, BlockPos pos) {
        int height = random.nextInt(5) + 3;
        int length = random.nextInt(5) + 3;
        int width = random.nextInt(5) + 3;
        int newX = pos.func_177958_n() - length / 2;
        int newY = pos.func_177956_o() + height / 2;
        int newZ = pos.func_177952_p() - width / 2;
        for (int i = 0; i < height; ++i) {
            for (int j = 0; j < length; ++j) {
                for (int k = 0; k < width; ++k) {
                    BlockPos newPos;
                    Block aux;
                    if (Utils.weightedChoise(0.7f, 0.3f, 0.0f, 0.0f, 0.0f, 0.0f) != 1 || (aux = sandEquivalent.get(world.func_180495_p(newPos = new BlockPos(newX + j, newY - i, newZ + k)).func_177230_c())) == null) continue;
                    world.func_180501_a(newPos, aux.func_176223_P(), 2);
                }
            }
        }
    }

    public static int getNumEmptyBlocks(World world, BlockPos pos) {
        int dist = 0;
        while (pos.func_177956_o() > 5 && !world.func_175677_d(pos, true) && world.func_175623_d(pos)) {
            pos = pos.func_177977_b();
            ++dist;
        }
        return dist;
    }

    public static int randomChoise(int ... val) {
        Random random = new Random();
        return val[random.nextInt(val.length)];
    }

    public static int weightedChoise(float par1, float par2, float par3, float par4, float par5, float par6) {
        float total = par1 + par2 + par3 + par4 + par5 + par6;
        float val = new Random().nextFloat();
        par1 /= total;
        par2 /= total;
        par3 /= total;
        par4 /= total;
        par5 /= total;
        if (val < par1) {
            return 1;
        }
        float previous = par1;
        if (val < par2 + previous) {
            return 2;
        }
        if (val < par3 + (previous += par2)) {
            return 3;
        }
        if (val < par4 + (previous += par3)) {
            return 4;
        }
        if (val < par5 + (previous += par4)) {
            return 5;
        }
        return 6;
    }

    static {
        sandEquivalent.put(Blocks.field_150348_b, Blocks.field_150322_A);
        sandEquivalent.put(Blocks.field_150346_d, (Block)Blocks.field_150354_m);
        sandEquivalent.put(Blocks.field_150351_n, (Block)Blocks.field_150354_m);
    }
}

