/*
 * Decompiled with CFR 0.152.
 */
package wildCaves;

import java.util.ArrayList;
import java.util.Arrays;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.WeightedRandomChestContent;
import net.minecraftforge.common.ChestGenHooks;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import wildCaves.BlockDecorations;
import wildCaves.BlockFlora;
import wildCaves.BlockFossils;
import wildCaves.BlockStalactite;
import wildCaves.BlockStoneStalactite;
import wildCaves.EventManager;
import wildCaves.ItemStalactite;
import wildCaves.MultiItemBlock;
import wildCaves.ServerProxy;
import wildCaves.WorldGenWildCaves;

@Mod(modid="wildcaves3", name="Wild Caves 3", version="1.8", acceptedMinecraftVersions="[1.8]")
public final class WildCaves {
    @SidedProxy(clientSide="wildCaves.ClientProxy", serverSide="wildCaves.ServerProxy")
    public static ServerProxy proxy;
    public static final ArrayList<String> stalacs;
    public static final ArrayList<String> sandStalacs;
    public static final ArrayList<String> icicles;
    public static final ArrayList<String> caps;
    public static final ArrayList<String> fossils;
    public static Block blockFlora;
    public static Block blockDecorations;
    public static Block blockFossils;
    public static Block blockStoneStalactite;
    public static Block blockSandStalactite;
    public static boolean solidStalactites;
    public static boolean damageWhenFallenOn;
    private static Configuration config;
    public static final CreativeTabs tabWildCaves;

    @Mod.EventHandler
    public void load(FMLInitializationEvent event) {
        WorldGenWildCaves gen = new WorldGenWildCaves(config);
        if (WorldGenWildCaves.maxLength > 0) {
            MinecraftForge.EVENT_BUS.register((Object)gen);
        }
        proxy.registerRenders();
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        int chestSkull;
        config = new Configuration(event.getSuggestedConfigurationFile());
        solidStalactites = config.getBoolean("Solid stalactites/stalgmites", "general", false, "Whether stalactites can be collided with.");
        damageWhenFallenOn = config.getBoolean("Stalgmites damage entities when fallen on", "general", false, "Whether living beings would be damaged when falling on the block.");
        int floraLightLevel = config.getInt("Flora light level", "general", 5, 0, 15, "How much light is emitted by the mushrooms.");
        blockStoneStalactite = GameRegistry.registerBlock((Block)new BlockStoneStalactite(), ItemStalactite.class, (String)"StoneStalactite", (Object[])new Object[]{stalacs});
        blockSandStalactite = GameRegistry.registerBlock((Block)new BlockStalactite(Item.func_150898_a((Block)Blocks.field_150322_A)).func_149663_c("sandstoneStalactiteBlock"), ItemStalactite.class, (String)"SandstoneSalactite", (Object[])new Object[]{sandStalacs});
        blockDecorations = GameRegistry.registerBlock((Block)new BlockDecorations(), MultiItemBlock.class, (String)"Decorations", (Object[])new Object[]{icicles});
        blockFlora = GameRegistry.registerBlock((Block)new BlockFlora().func_149715_a(floraLightLevel), MultiItemBlock.class, (String)"Flora", (Object[])new Object[]{caps});
        blockFossils = GameRegistry.registerBlock((Block)new BlockFossils(), MultiItemBlock.class, (String)"FossilBlock", (Object[])new Object[]{fossils});
        int chanceForNodeToSpawn = config.get("general", "Chance for a fossil node to generate", 5).getInt();
        if (chanceForNodeToSpawn > 0) {
            MinecraftForge.ORE_GEN_BUS.register((Object)new EventManager(chanceForNodeToSpawn));
        }
        if ((chestSkull = config.get("general", "Chance for a skull to be added in chests", 50).getInt()) > 0) {
            for (String txt : new String[]{"dungeonChest", "mineshaftCorridor", "strongholdCorridor"}) {
                for (int i = 0; i < 5; ++i) {
                    if (i == 1) continue;
                    ChestGenHooks.getInfo((String)txt).addItem(new WeightedRandomChestContent(new ItemStack(Items.field_151144_bL, 1, i), 1, 2, chestSkull));
                }
            }
        }
        if (event.getSourceFile().getName().endsWith(".jar")) {
            proxy.MUD();
        }
    }

    static {
        stalacs = new ArrayList<String>(Arrays.asList("stalactite1", "stalactite2", "stalactite3", "stalactite4", "stalactiteConnection1", "stalactiteConnection2", "stalactiteConnection3", "stalactiteConnection4", "stalactiteEnd", "stalacmiteEnd", "stalacmite1", "stalacmite2", "stalacmite3"));
        sandStalacs = new ArrayList<String>(Arrays.asList("sandstoneStalactite1", "sandstoneStalactite2", "sandstoneStalactite3", "sandstoneStalactite4", "sandstoneStalactiteConnection1", "sandstoneStalactiteConnection2", "sandstoneStalactiteConnection3", "sandstoneStalactiteConnection4", "sandstoneStalactiteEnd", "sandstoneStalacmiteEnd", "sandstoneStalacmite1", "sandstoneStalacmite2", "sandstoneStalacmite3"));
        icicles = new ArrayList<String>(Arrays.asList("icicle1", "icicle2", "icicle3"));
        caps = new ArrayList<String>(Arrays.asList("glowcap1", "glowcap2", "glowcap3", "gloweed1", "glowcap4top", "glowcap4bottom", "bluecap1", "bluecap2", "bluecap3", "bluecap4"));
        fossils = new ArrayList<String>(Arrays.asList("fossil1"));
        tabWildCaves = new CreativeTabs("WildCaves3"){

            public Item func_78016_d() {
                return Items.field_151061_bv;
            }
        };
    }
}

