/*
 * Decompiled with CFR 0.152.
 */
package wildCaves;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.util.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.event.terraingen.DecorateBiomeEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameData;
import wildCaves.Utils;
import wildCaves.generation.biomeGen.GenerationArid;
import wildCaves.generation.biomeGen.GenerationFrozen;
import wildCaves.generation.biomeGen.GenerationHumid;
import wildCaves.generation.biomeGen.GenerationJungle;
import wildCaves.generation.biomeGen.GenerationNormal;

public final class WorldGenWildCaves {
    public static float probabilityVinesJungle;
    public static float probabilityVines;
    public static float probabilityIcicle;
    public static float probabilityWet;
    public static float probabilityDry;
    public static float probabilityGlowcapsHumid;
    public static float probabilityGlowcaps;
    public static float probabilityIceshrooms;
    public static float probabilityStalactite;
    public static float probabilitySpiderWeb;
    public static float probabilitySandStalactites;
    public static float probabilitySkulls;
    public static int maxGenHeight;
    public static int maxLength;
    private static int timesPerChunck;
    public static int maxGenHeightGlowcapNormal;
    public static List<Integer> dimensionBlacklist;
    private static List<Block> blockWhiteList;
    private static final GenerationJungle jungleGen;
    private static final GenerationHumid wetGen;
    private static final GenerationArid aridGen;
    private static final GenerationNormal normalGen;
    private static final GenerationFrozen frozenGen;

    public WorldGenWildCaves(Configuration config) {
        WorldGenWildCaves.setConfig(config);
    }

    public static boolean isWhiteListed(Block block) {
        return blockWhiteList.contains(block);
    }

    @SubscribeEvent
    public void decorate(DecorateBiomeEvent.Post decorationEvent) {
        this.generate(decorationEvent.rand, decorationEvent.pos.func_177982_a(8, 0, 8), decorationEvent.world);
    }

    public void generate(Random random, BlockPos pos, World world) {
        if (!dimensionBlacklist.contains(world.field_73011_w.func_177502_q())) {
            for (int i = 0; i < timesPerChunck; ++i) {
                BlockPos coord = pos.func_177982_a(random.nextInt(16), 0, random.nextInt(16));
                coord = new BlockPos(pos.func_177958_n(), Math.min(world.func_175645_m(coord).func_177956_o() - 1, random.nextInt(maxGenHeight)), pos.func_177952_p());
                while (!(coord.func_177956_o() <= 10 || blockWhiteList.contains(world.func_180495_p(coord.func_177984_a()).func_177230_c()) && world.func_175623_d(coord))) {
                    coord = coord.func_177977_b();
                }
                if (coord.func_177956_o() <= 10) continue;
                BiomeGenBase biome = world.func_180494_b(coord);
                if (BiomeDictionary.isBiomeOfType((BiomeGenBase)biome, (BiomeDictionary.Type)BiomeDictionary.Type.FROZEN)) {
                    frozenGen.func_180709_b(world, random, coord);
                    continue;
                }
                if (biome.field_76750_F > 1.5f && biome.field_76751_G < 0.1f) {
                    aridGen.func_180709_b(world, random, coord);
                    continue;
                }
                if (BiomeDictionary.isBiomeOfType((BiomeGenBase)biome, (BiomeDictionary.Type)BiomeDictionary.Type.JUNGLE)) {
                    jungleGen.func_180709_b(world, random, coord);
                    continue;
                }
                if (biome.func_76736_e() || BiomeDictionary.isBiomeOfType((BiomeGenBase)biome, (BiomeDictionary.Type)BiomeDictionary.Type.WATER)) {
                    wetGen.func_180709_b(world, random, coord);
                    continue;
                }
                normalGen.func_180709_b(world, random, coord);
            }
        }
    }

    private static void setConfig(Configuration config) {
        Block block;
        String[] list;
        String category = "Permissions";
        boolean sandstoneStalactites = config.get(category, "Generate Sandstone stalactites on arid biomes", true).getBoolean(true);
        boolean flora = config.get(category, "Generate flora on caves", true).getBoolean(true);
        boolean stalactites = config.get(category, "Generate stalactites on caves", true).getBoolean(true);
        for (String text : list = config.get(category, "Dimension Blacklist", "-1,1", "Worlds where generation won't occur, by dimension ids. Use [id1;id2] to add a range of id, prefix with - to exclude.").getString().split(",")) {
            String[] results;
            if (text == null || text.isEmpty()) continue;
            boolean done = false;
            if (text.contains("[") && text.contains("]") && (results = text.substring(text.indexOf("[") + 1, text.indexOf("]")).split(";")).length == 2) {
                try {
                    int a = Integer.parseInt(results[0]);
                    int b = Integer.parseInt(results[1]);
                    boolean remove = text.startsWith("-");
                    for (int x = a; x <= b; ++x) {
                        if (remove) {
                            dimensionBlacklist.remove(x);
                            continue;
                        }
                        dimensionBlacklist.add(x);
                    }
                    done = true;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (done) continue;
            try {
                dimensionBlacklist.add(Integer.parseInt(text.trim()));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        for (String txt : list = config.get(category, "Block white list", "stone,grass,dirt,cobblestone,gravel,gold_ore,iron_ore,coal_ore,lapis_ore,sandstone,diamond_ore,redstone_ore,lit_redstone_ore,ice,snow,clay,monster_egg,emerald_ore").getString().split(",")) {
            try {
                block = (Block)GameData.getBlockRegistry().func_82594_a((Object)txt.trim());
                if (block == null || block.func_149688_o() == Material.field_151579_a) continue;
                blockWhiteList.add(block);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        category = "Biome specific";
        probabilityVinesJungle = (float)config.get(category, "Probability of vines on jungle caves", 0.5).getDouble(0.5);
        probabilityIcicle = (float)config.get(category, "Probability of icicles on frozen caves", 0.6).getDouble(0.6);
        try {
            block = (Block)GameData.getBlockRegistry().func_82594_a((Object)config.get(category, "Block to generate in frozen caves", "ice").getString().trim());
            if (block != null && block.func_149688_o().func_151565_r() == MapColor.field_151657_g) {
                Utils.frozen = block;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        probabilityWet = (float)config.get(category, "Probability of more water fountains on wet caves", 0.1).getDouble(0.1);
        probabilityDry = (float)config.get(category, "Probability of less generation arid caves", 0.5).getDouble(0.5);
        probabilityGlowcapsHumid = (float)config.get(category, "Probability of Glowing mushrooms on humid/jungle caves", 0.3).getDouble(0.3);
        probabilityIceshrooms = (float)config.get(category, "Probability of Glowing Ice mushrooms on frozen caves", 0.3).getDouble(0.3);
        probabilitySandStalactites = (float)config.get(category, "Probability of sandstone stalactites on arid caves", 0.5).getDouble(0.5);
        category = "Non biome specific";
        probabilityVines = (float)config.get(category, "Probability of vines on caves", 0.1).getDouble(0.1);
        probabilityGlowcaps = (float)config.get(category, "Probability of glowing mushrooms on caves", 0.1).getDouble(0.1);
        probabilityStalactite = (float)config.get(category, "Probability of Stalactites/stalagmites", 0.5).getDouble(0.5);
        probabilitySpiderWeb = (float)config.get(category, "Probability of spider webs", 0.15).getDouble(0.15);
        maxGenHeightGlowcapNormal = config.get(category, "Max height at which to generate glowcaps on normal biomes", 30).getInt();
        probabilitySkulls = (float)config.get(category, "Probability of skulls", 1.0E-4).getDouble(1.0E-4);
        if (!sandstoneStalactites) {
            probabilitySandStalactites = 0.0f;
        }
        if (!flora) {
            probabilityGlowcaps = 0.0f;
            probabilityVinesJungle = 0.0f;
            probabilityGlowcapsHumid = 0.0f;
            probabilityIceshrooms = 0.0f;
            probabilityVines = 0.0f;
            probabilityGlowcaps = 0.0f;
        }
        if (!stalactites) {
            probabilityStalactite = 0.0f;
            probabilitySandStalactites = 0.0f;
        }
        category = "general";
        timesPerChunck = config.get(category, "times to attempt generating per chunk", 40).getInt();
        maxGenHeight = config.get(category, "Max height at which to generate", 80).getInt();
        maxLength = config.get(category, "Max length of structure generation", 8).getInt();
        if (config.hasChanged()) {
            config.save();
        }
    }

    static {
        timesPerChunck = 50;
        dimensionBlacklist = new ArrayList<Integer>();
        blockWhiteList = new ArrayList<Block>();
        jungleGen = new GenerationJungle();
        wetGen = new GenerationHumid();
        aridGen = new GenerationArid();
        normalGen = new GenerationNormal();
        frozenGen = new GenerationFrozen();
    }
}

