/*
 * Decompiled with CFR 0.152.
 */
package wildCaves.generation.structureGen;

import java.util.Random;
import net.minecraft.block.BlockVine;
import net.minecraft.block.properties.IProperty;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntitySkull;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import wildCaves.Utils;
import wildCaves.WildCaves;

public final class DecorationHelper {
    public static void generateFloodedCaves(World world, Random random, BlockPos pos) {
        int blocks = 0;
        int x = pos.func_177958_n();
        int z = pos.func_177952_p();
        for (int i = x - 3; i < x + 3; ++i) {
            for (int k = z - 3; k < z + 3; ++k) {
                if ((blocks += Utils.getNumEmptyBlocks(world, new BlockPos(i, pos.func_177956_o(), k))) <= 400) continue;
                return;
            }
        }
        if (blocks > 150) {
            int y = pos.func_177956_o() - Utils.getNumEmptyBlocks(world, pos) / 3;
            System.out.println(pos);
            for (int i = x - 6; i < x + 6; ++i) {
                for (int k = z - 7; k < z + 7; ++k) {
                    BlockPos temp = new BlockPos(i, y, k);
                    if (!world.func_175623_d(temp)) continue;
                    world.func_180501_a(temp, Blocks.field_150358_i.func_176223_P(), 2);
                    ++k;
                }
            }
        }
    }

    public static boolean generateGlowcaps(World world, Random random, BlockPos pos) {
        int vary = Utils.getNumEmptyBlocks(world, pos);
        if (vary != 0) {
            pos = pos.func_177979_c(vary - 1);
        }
        if (!world.func_175623_d(pos.func_177977_b())) {
            int glowcapNum = world.func_175623_d(pos.func_177984_a()) ? random.nextInt(5) : random.nextInt(4);
            world.func_180501_a(pos, WildCaves.blockFlora.func_176203_a(glowcapNum), 2);
            if (glowcapNum == 4) {
                world.func_180501_a(pos.func_177984_a(), WildCaves.blockFlora.func_176203_a(glowcapNum + 1), 2);
            }
            return true;
        }
        return false;
    }

    public static void generateIceshrooms(World world, Random random, BlockPos pos) {
        int vary = Utils.getNumEmptyBlocks(world, pos);
        if (vary != 0) {
            pos = pos.func_177979_c(vary - 1);
        }
        if (!world.func_175623_d(pos.func_177977_b())) {
            if (!world.func_180495_p(pos).func_177230_c().func_149688_o().func_76224_d()) {
                world.func_180501_a(pos.func_177977_b(), Utils.frozen.func_176223_P(), 2);
                world.func_180501_a(pos, WildCaves.blockFlora.func_176203_a(Utils.randomChoise(6, 7, 8, 9)), 2);
            }
            Utils.convertToFrozenType(world, random, pos);
        }
    }

    public static void generateIcicles(World world, Random random, BlockPos pos, int distance) {
        world.func_180501_a(pos.func_177984_a(), Utils.frozen.func_176223_P(), 2);
        world.func_180501_a(pos, WildCaves.blockDecorations.func_176203_a(Utils.randomChoise(0, 1, 2)), 2);
        Utils.convertToFrozenType(world, random, pos);
        BlockPos botY = pos.func_177979_c(distance - 1);
        if (distance != 0 && !world.func_180495_p(botY).func_177230_c().func_149688_o().func_76224_d()) {
            Utils.convertToFrozenType(world, random, botY);
        }
    }

    public static void generateSkulls(World world, Random random, BlockPos pos, int numEmptyBlocks) {
        BlockPos auxY;
        if (numEmptyBlocks > 0 && (auxY = pos.func_177979_c(numEmptyBlocks - 1)).func_177956_o() > 0 && numEmptyBlocks > 0) {
            world.func_180501_a(auxY, Blocks.field_150465_bP.func_176203_a(1), 2);
            TileEntity skullTE = world.func_175625_s(auxY);
            if (skullTE instanceof TileEntitySkull) {
                ((TileEntitySkull)skullTE).func_145903_a(random.nextInt(360));
            }
        }
    }

    public static void generateVines(World world, Random random, BlockPos pos) {
        int distance = Utils.getNumEmptyBlocks(world, pos);
        int aux = distance > 5 ? random.nextInt(distance - 5) + 5 : distance;
        EnumFacing side = EnumFacing.values()[random.nextInt(4) + 2];
        for (int i = 0; i < aux && !world.func_180495_p(pos.func_177979_c(i)).func_177230_c().func_149688_o().func_76224_d(); ++i) {
            world.func_180501_a(pos.func_177979_c(i), Blocks.field_150395_bd.func_176223_P().func_177226_a((IProperty)BlockVine.func_176267_a((EnumFacing)side), (Comparable)Boolean.valueOf(true)), 0);
        }
    }
}

