/*
 * Decompiled with CFR 0.152.
 */
package de.universallp.justenoughbuttons.client;

import de.universallp.justenoughbuttons.JEIButtons;
import de.universallp.justenoughbuttons.client.ClientProxy;
import de.universallp.justenoughbuttons.core.handlers.ConfigHandler;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.client.config.GuiUtils;

public enum EnumButtonCommands {
    CREATIVE("gamemode 1", 5, 5),
    ADVENTURE("gamemode 2", 5, 5),
    SURVIVAL("gamemode 0", 5, 5),
    SPECTATE("gamemode 3", 5, 5),
    DELETE("clear ", 65, 5),
    RAIN("weather rain", 25, 5),
    SUN("weather clear", 45, 5),
    DAY("time set day", 5, 26),
    NIGHT("time set night", 25, 26),
    FREEZETIME("gamerule doDaylightCycle", 25, 47),
    NOMOBS("kill @e[type=!Player]", 5, 47),
    MAGNET("tp", 25, 47),
    CUSTOM1("", 5, 68, 0),
    CUSTOM2("", 25, 68, 1),
    CUSTOM3("", 5, 89, 2),
    CUSTOM4("", 25, 89, 3);

    public boolean isEnabled = true;
    public boolean isVisible = true;
    String command;
    JEIButtons.EnumButtonState state = JEIButtons.EnumButtonState.DISABLED;
    public static final int width = 18;
    public static final int height = 19;
    public int xPos;
    public int yPos;
    public byte id;
    static final ResourceLocation icons;

    private EnumButtonCommands(String commandToExecute, int x, int y) {
        this.command = commandToExecute;
        this.xPos = x;
        this.yPos = y;
    }

    private EnumButtonCommands(String commandToExecute, int x, int y, int id) {
        this.id = (byte)id;
        this.command = commandToExecute;
        this.xPos = x;
        this.yPos = y;
    }

    public void setEnabled(boolean b) {
        this.isEnabled = b;
    }

    public void setPosition(int x, int y) {
        this.xPos = x;
        this.yPos = y;
    }

    public void setVisible(boolean visible) {
        this.isVisible = visible;
    }

    public EnumButtonCommands cycle() {
        if (this.ordinal() == 0) {
            return EnumButtonCommands.ADVENTURE.isEnabled ? ADVENTURE : SURVIVAL;
        }
        if (this.ordinal() == 1) {
            return SURVIVAL;
        }
        if (this.ordinal() == 2) {
            return EnumButtonCommands.SPECTATE.isEnabled ? SPECTATE : CREATIVE;
        }
        if (this.ordinal() == 3) {
            return CREATIVE;
        }
        return this;
    }

    public void draw() {
        if (!this.isVisible || this.getCommand().equals("")) {
            return;
        }
        int mouseX = JEIButtons.proxy.getMouseX();
        int mouseY = JEIButtons.proxy.getMouseY();
        if (this.isEnabled) {
            if (mouseX >= this.xPos && mouseX <= this.xPos + 18 && mouseY >= this.yPos && mouseY <= this.yPos + 19) {
                this.state = JEIButtons.EnumButtonState.HOVERED;
                JEIButtons.hoveredButton = this;
                JEIButtons.isAnyButtonHovered = true;
            } else {
                this.state = JEIButtons.EnumButtonState.ENABLED;
            }
        } else {
            if (mouseX >= this.xPos && mouseX <= this.xPos + 18 && mouseY >= this.yPos && mouseY <= this.yPos + 19) {
                JEIButtons.hoveredButton = this;
                JEIButtons.isAnyButtonHovered = true;
            }
            this.state = JEIButtons.EnumButtonState.DISABLED;
        }
        ClientProxy.mc.field_71446_o.func_110577_a(icons);
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        GuiUtils.drawTexturedModalRect((int)this.xPos, (int)this.yPos, (int)(18 * this.iconID()), (int)(19 * this.state.ordinal()), (int)18, (int)19, (float)1.0f);
        RenderHelper.func_74518_a();
    }

    public String getCommand() {
        return this.ordinal() > MAGNET.ordinal() ? ConfigHandler.customCommand[this.id] : this.command;
    }

    public int iconID() {
        if (this == MAGNET) {
            return 12;
        }
        return this.ordinal() > MAGNET.ordinal() ? 11 : this.ordinal();
    }

    static {
        icons = new ResourceLocation("justenoughbuttons", "textures/icons.png");
    }
}

