/*
 * Decompiled with CFR 0.152.
 */
package de.universallp.justenoughbuttons;

import de.universallp.justenoughbuttons.client.ClientProxy;
import de.universallp.justenoughbuttons.core.CommonProxy;
import de.universallp.justenoughbuttons.core.InventorySaveHandler;
import java.io.File;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod(modid="justenoughbuttons", version="1.11-1.3", clientSideOnly=true, guiFactory="de.universallp.justenoughbuttons.client.GuiFactory", acceptedMinecraftVersions="[1.11]")
public class JEIButtons {
    public static final String MODID = "justenoughbuttons";
    public static final String VERSION = "1.11-1.3";
    public static final String MOD_MOREOVERLAYS = "moreoverlays";
    public static boolean isServerSidePresent = false;
    public static boolean enableOverlays = true;
    @Mod.Instance
    public static JEIButtons instance;
    @SidedProxy(clientSide="de.universallp.justenoughbuttons.client.ClientProxy", serverSide="de.universallp.justenoughbuttons.core.CommonProxy")
    public static CommonProxy proxy;
    public static EnumButtonCommands btnGameMode;
    public static EnumButtonCommands btnTrash;
    public static EnumButtonCommands btnSun;
    public static EnumButtonCommands btnRain;
    public static EnumButtonCommands btnDay;
    public static EnumButtonCommands btnNight;
    public static EnumButtonCommands btnNoMobs;
    public static EnumButtonCommands btnFreeze;
    public static EnumButtonCommands btnMagnet;
    public static EnumButtonCommands[] btnCustom;
    public static boolean configHasChanged;
    public static EnumButtonCommands hoveredButton;
    public static boolean isAnyButtonHovered;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        ConfigHandler.loadConfig(event.getSuggestedConfigurationFile());
        proxy.preInit(event);
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        proxy.init(event);
        proxy.registerKeyBind();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        ConfigHandler.loadPostInit();
        JEIButtons.setUpPositions();
        proxy.postInit(event);
    }

    private static boolean canExecuteCommand(String c) {
        return ClientProxy.player.func_70003_b(1, c);
    }

    public static void setUpPositions() {
        EnumButtonCommands[] btns = new EnumButtonCommands[]{btnGameMode, btnRain, btnSun, btnTrash, btnDay, btnNight, btnNoMobs, btnFreeze, btnMagnet, btnCustom[0], btnCustom[1], btnCustom[2], btnCustom[3]};
        int x = 0;
        int y = 0;
        for (EnumButtonCommands b : btns) {
            if (!b.isVisible) continue;
            b.setPosition(20 * x + ConfigHandler.xOffset, 21 * y + ConfigHandler.yOffset);
            if (y == 0 && ++x == 4) {
                ++y;
                x = 0;
                continue;
            }
            if (y == 1 && x == 3) {
                ++y;
                x = 0;
                continue;
            }
            if (x % 2 != 0 || y <= 1) continue;
            x = 0;
            ++y;
        }
        EnumButtonCommands.CREATIVE.setPosition(JEIButtons.btnGameMode.xPos, JEIButtons.btnGameMode.yPos);
        EnumButtonCommands.SPECTATE.setPosition(JEIButtons.btnGameMode.xPos, JEIButtons.btnGameMode.yPos);
        EnumButtonCommands.ADVENTURE.setPosition(JEIButtons.btnGameMode.xPos, JEIButtons.btnGameMode.yPos);
        InventorySaveHandler.init();
    }

    static {
        btnGameMode = EnumButtonCommands.SURVIVAL;
        btnTrash = EnumButtonCommands.DELETE;
        btnSun = EnumButtonCommands.SUN;
        btnRain = EnumButtonCommands.RAIN;
        btnDay = EnumButtonCommands.DAY;
        btnNight = EnumButtonCommands.NIGHT;
        btnNoMobs = EnumButtonCommands.NOMOBS;
        btnFreeze = EnumButtonCommands.FREEZETIME;
        btnMagnet = EnumButtonCommands.MAGNET;
        btnCustom = new EnumButtonCommands[]{EnumButtonCommands.CUSTOM1, EnumButtonCommands.CUSTOM2, EnumButtonCommands.CUSTOM3, EnumButtonCommands.CUSTOM4};
        configHasChanged = false;
    }

    public static class ConfigHandler {
        public static boolean enableAdventureMode = true;
        public static boolean enableSpectatoreMode = true;
        public static boolean enableSaves = true;
        public static int magnetRadius = 8;
        public static boolean enableClearInventory = false;
        static boolean enableGamemode = true;
        static boolean enableDelete = true;
        static boolean enableTime = true;
        static boolean enableWeather = true;
        static boolean enableKillMobs = true;
        static boolean enableDayCycle = true;
        static boolean enableMagnet = true;
        static boolean[] enableCustom = new boolean[]{false, false, false, false};
        public static String[] customCommand = new String[]{"help", "help", "help", "help"};
        public static String[] customName = new String[]{"Print Help", "Print Help", "Print Help", "Print Help"};
        static final String CATEGORY = "buttons";
        public static final String CATEGORY_CUSTOM = "custombuttons";
        public static final String CATEGORY_POSITION = "position";
        public static int yOffset;
        public static int xOffset;
        public static boolean showButtons;
        public static Configuration config;

        static void load() {
            int i;
            showButtons = config.getBoolean("showButtons", CATEGORY, true, "When false no button will be shown");
            enableAdventureMode = config.getBoolean("enableAdventureMode", CATEGORY, true, "When false the gamemode button won't allow you to switch to adventure mode");
            enableSpectatoreMode = config.getBoolean("enableSpectatoreMode", CATEGORY, true, "When false the gamemode button won't allow you to switch to spectator mode");
            enableGamemode = config.getBoolean("enableGamemode", CATEGORY, true, "When false the gamemode button will be disabled");
            enableDelete = config.getBoolean("enableDelete", CATEGORY, true, "When false the delete button will be disabled");
            enableWeather = config.getBoolean("enableWeather", CATEGORY, true, "When false the weather buttons will be disabled");
            enableTime = config.getBoolean("enableTime", CATEGORY, true, "When false the time buttons will be disabled");
            enableKillMobs = config.getBoolean("enableKillMobs", CATEGORY, true, "When false the kill entities button will be disabled");
            enableDayCycle = config.getBoolean("enableDayCycle", CATEGORY, true, "When false the freeze time button will be disabled");
            enableMagnet = config.getBoolean("enableMagnet", CATEGORY, true, "When false the magnet mode button will be disabled");
            yOffset = config.getInt("yOffset", CATEGORY_POSITION, 5, 0, 1024, "Y offset of the buttons");
            xOffset = config.getInt("xOffset", CATEGORY_POSITION, 5, 0, 1024, "X offset of the buttons");
            enableSaves = config.getBoolean("enableSaves", CATEGORY, true, "When false the four save slots will be disabled");
            magnetRadius = config.getInt("magnetRadius", CATEGORY, 12, 1, 32, "The radius in which the magnet mode attracts items");
            enableClearInventory = config.getBoolean("enableClearInventory", CATEGORY, false, "When true shift clicking the delete buttonwill clear your inventory");
            for (i = 0; i < enableCustom.length; ++i) {
                ConfigHandler.enableCustom[i] = config.getBoolean("enableCustomButton." + i, CATEGORY_CUSTOM, false, "When true you'll get a button, which executes a custom command");
                ConfigHandler.customCommand[i] = config.getString("customCommand." + i, CATEGORY_CUSTOM, "help", "The command to be executed by the custom button");
                ConfigHandler.customName[i] = config.getString("customName." + i, CATEGORY_CUSTOM, "Print Help", "The tooltip of the custom button");
            }
            EnumButtonCommands.ADVENTURE.setEnabled(enableAdventureMode);
            EnumButtonCommands.SPECTATE.setEnabled(enableSpectatoreMode);
            btnGameMode.setVisible(enableGamemode);
            btnDay.setVisible(enableTime);
            btnNight.setVisible(enableTime);
            btnTrash.setVisible(enableDelete);
            btnNoMobs.setVisible(enableKillMobs);
            btnFreeze.setVisible(enableDayCycle);
            btnRain.setVisible(enableWeather);
            btnSun.setVisible(enableWeather);
            btnMagnet.setVisible(enableMagnet);
            for (i = 0; i < btnCustom.length; ++i) {
                btnCustom[i].setVisible(enableCustom[i]);
            }
            if (config.hasChanged()) {
                config.save();
            }
        }

        static void loadPostInit() {
            if (config.hasChanged()) {
                config.save();
            }
        }

        static void loadConfig(File configFile) {
            if (config == null) {
                config = new Configuration(configFile);
            }
            ConfigHandler.load();
            MinecraftForge.EVENT_BUS.register((Object)new ConfigHandler());
        }

        @SubscribeEvent
        public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent eventArgs) {
            if (eventArgs.getModID().equals(JEIButtons.MODID)) {
                config.save();
                ConfigHandler.load();
                configHasChanged = true;
            }
        }

        static {
            showButtons = true;
        }
    }

    public static enum EnumButtonState {
        DISABLED,
        ENABLED,
        HOVERED;

    }

    public static enum EnumButtonCommands {
        CREATIVE("gamemode 1", 5, 5),
        ADVENTURE("gamemode 2", 5, 5),
        SURVIVAL("gamemode 0", 5, 5),
        SPECTATE("gamemode 3", 5, 5),
        DELETE("clear ", 65, 5),
        RAIN("weather rain", 25, 5),
        SUN("weather clear", 45, 5),
        DAY("time set day", 5, 26),
        NIGHT("time set night", 25, 26),
        FREEZETIME("gamerule doDaylightCycle", 25, 47),
        NOMOBS("kill @e[type=!Player]", 5, 47),
        MAGNET("tp", 25, 47),
        CUSTOM1("", 5, 68, 0),
        CUSTOM2("", 25, 68, 1),
        CUSTOM3("", 5, 89, 2),
        CUSTOM4("", 25, 89, 3);

        public boolean isEnabled = true;
        boolean isVisible = true;
        String command;
        EnumButtonState state = EnumButtonState.DISABLED;
        static final int width = 18;
        static final int height = 19;
        int xPos;
        int yPos;
        public byte id;
        static final ResourceLocation icons;

        private EnumButtonCommands(String commandToExecute, int x, int y) {
            this.command = commandToExecute;
            this.xPos = x;
            this.yPos = y;
        }

        private EnumButtonCommands(String commandToExecute, int x, int y, int id) {
            this.id = (byte)id;
            this.command = commandToExecute;
            this.xPos = x;
            this.yPos = y;
        }

        public void setEnabled(boolean b) {
            this.isEnabled = b;
        }

        public void setPosition(int x, int y) {
            this.xPos = x;
            this.yPos = y;
        }

        public void setVisible(boolean visible) {
            this.isVisible = visible;
        }

        public EnumButtonCommands cycle() {
            if (this.ordinal() == 0) {
                return EnumButtonCommands.ADVENTURE.isEnabled ? ADVENTURE : SURVIVAL;
            }
            if (this.ordinal() == 1) {
                return SURVIVAL;
            }
            if (this.ordinal() == 2) {
                return EnumButtonCommands.SPECTATE.isEnabled ? SPECTATE : CREATIVE;
            }
            if (this.ordinal() == 3) {
                return CREATIVE;
            }
            return this;
        }

        public void draw(GuiContainer parent) {
            if (!this.isVisible || this.getCommand().equals("")) {
                return;
            }
            int mouseX = proxy.getMouseX();
            int mouseY = proxy.getMouseY();
            if (this.isEnabled) {
                if (JEIButtons.canExecuteCommand(this.getCommand())) {
                    if (mouseX >= this.xPos && mouseX <= this.xPos + 18 && mouseY >= this.yPos && mouseY <= this.yPos + 19) {
                        this.state = EnumButtonState.HOVERED;
                        hoveredButton = this;
                        isAnyButtonHovered = true;
                    } else {
                        this.state = EnumButtonState.ENABLED;
                    }
                } else {
                    this.state = EnumButtonState.DISABLED;
                }
            } else {
                if (mouseX >= this.xPos && mouseX <= this.xPos + 18 && mouseY >= this.yPos && mouseY <= this.yPos + 19) {
                    hoveredButton = this;
                    isAnyButtonHovered = true;
                }
                this.state = EnumButtonState.DISABLED;
            }
            parent.field_146297_k.field_71446_o.func_110577_a(icons);
            GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
            parent.func_73729_b(this.xPos, this.yPos, 18 * this.iconID(), 19 * this.state.ordinal(), 18, 19);
            RenderHelper.func_74518_a();
        }

        public String getCommand() {
            return this.ordinal() > MAGNET.ordinal() ? ConfigHandler.customCommand[this.id] : this.command;
        }

        public int iconID() {
            if (this == MAGNET) {
                return 12;
            }
            return this.ordinal() > MAGNET.ordinal() ? 11 : this.ordinal();
        }

        static {
            icons = new ResourceLocation(JEIButtons.MODID, "textures/icons.png");
        }
    }
}

