/*
 * Decompiled with CFR 0.152.
 */
package de.universallp.justenoughbuttons.core;

import com.mojang.authlib.GameProfile;
import de.universallp.justenoughbuttons.client.ClientProxy;
import de.universallp.justenoughbuttons.core.InventorySaveHandler;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTException;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.FMLLog;
import org.apache.logging.log4j.Level;

public class SaveFileHandler {
    public static boolean SAVE_SNAPSHOTS = true;
    private static boolean HAS_LOADED = false;
    private static String savePath;

    public SaveFileHandler init() {
        savePath = ClientProxy.mc.field_71412_D.toString() + "/mods/JustEnoughButtons";
        File saveFolder = new File(savePath);
        if (!saveFolder.exists()) {
            FMLLog.log((String)"justenoughbuttons", (Level)Level.INFO, (String)"No save folder for inventory snapshots found. Creating it under %s", (Object[])new Object[]{savePath});
            if (!saveFolder.mkdir()) {
                FMLLog.log((String)"justenoughbuttons", (Level)Level.ERROR, (String)"Couldn't create folder. Saving of inventory snapshots is disabled!", (Object[])new Object[0]);
                SAVE_SNAPSHOTS = false;
            }
        }
        return this;
    }

    public void loadForPlayer() throws FileNotFoundException {
        if (HAS_LOADED) {
            return;
        }
        HAS_LOADED = true;
        UUID uuid = EntityPlayer.func_146094_a((GameProfile)Minecraft.func_71410_x().func_110432_I().func_148256_e());
        File saveFolder = new File(savePath);
        File saveFile = null;
        if (uuid != null) {
            for (File f : saveFolder.listFiles()) {
                if (!f.getName().contains(uuid.toString())) continue;
                saveFile = f;
                break;
            }
        }
        if (saveFile != null) {
            FMLLog.log((String)"justenoughbuttons", (Level)Level.INFO, (String)"Found savefile for user!", (Object[])new Object[0]);
            try {
                String line;
                BufferedReader br = new BufferedReader(new FileReader(saveFile));
                NBTTagCompound[] mainInventory = new NBTTagCompound[36];
                NBTTagCompound[] armorInventory = new NBTTagCompound[4];
                NBTTagCompound offHand = new NBTTagCompound();
                NBTTagCompound icon = new NBTTagCompound();
                int invIndex = 0;
                int armorIndex = 0;
                int saveIndex = 0;
                while ((line = br.readLine()) != null) {
                    if (line.startsWith("MainInv:")) {
                        mainInventory[invIndex] = JsonToNBT.func_180713_a((String)line.substring(8));
                        ++invIndex;
                        continue;
                    }
                    if (line.startsWith("NullInv")) {
                        ++invIndex;
                        continue;
                    }
                    if (line.startsWith("ArmoInv:")) {
                        armorInventory[armorIndex] = JsonToNBT.func_180713_a((String)line.substring(8));
                        ++armorIndex;
                        continue;
                    }
                    if (line.startsWith("NullArm")) {
                        ++armorIndex;
                        continue;
                    }
                    if (line.startsWith("OffHand:")) {
                        offHand = JsonToNBT.func_180713_a((String)line.substring(8));
                        continue;
                    }
                    if (line.startsWith("IconSta:")) {
                        icon = JsonToNBT.func_180713_a((String)line.substring(8));
                        continue;
                    }
                    if (line.startsWith("EMPTY SAVE")) {
                        ++saveIndex;
                        continue;
                    }
                    if (line.startsWith("END SAVE")) {
                        InventorySaveHandler.saves[saveIndex] = new InventorySaveHandler.InventorySnapshot(icon.func_74737_b(), (NBTTagCompound[])mainInventory.clone(), (NBTTagCompound[])armorInventory.clone(), offHand.func_74737_b());
                        ++saveIndex;
                        invIndex = 0;
                        armorIndex = 0;
                        mainInventory = new NBTTagCompound[36];
                        armorInventory = new NBTTagCompound[4];
                        offHand = new NBTTagCompound();
                        icon = new NBTTagCompound();
                        continue;
                    }
                    if (!line.startsWith("EOF")) continue;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (NBTException e) {
                e.printStackTrace();
            }
        } else {
            FMLLog.log((String)"justenoughbuttons", (Level)Level.INFO, (String)"No save file available.", (Object[])new Object[0]);
        }
    }

    public void saveForPlayer() throws FileNotFoundException, UnsupportedEncodingException {
        UUID uuid = EntityPlayer.func_146094_a((GameProfile)ClientProxy.player.func_146103_bH());
        File oldFile = new File(savePath + "/" + uuid + ".jebs");
        if (oldFile.exists() && !oldFile.delete()) {
            FMLLog.log((String)"justenoughbuttons", (Level)Level.ERROR, (String)"Error deleting old snapshot save. Saving of inventory snapshots will not be available!", (Object[])new Object[0]);
            SAVE_SNAPSHOTS = false;
        }
        File saveFile = new File(savePath + "/" + uuid + ".jebs");
        PrintWriter writer = new PrintWriter(saveFile, "UTF-8");
        writer.println("# JustEnoughButtons Save file for " + ClientProxy.player.getDisplayNameString() + ", " + uuid.toString());
        writer.println("# Created " + new Date(System.currentTimeMillis()));
        writer.println("# WARNING: Modifying this file might result in crashes!");
        for (int i = 0; i < 4; ++i) {
            InventorySaveHandler.InventorySnapshot snapshot = InventorySaveHandler.saves[i];
            if (snapshot != null) {
                for (NBTTagCompound nbt : snapshot.mainInventory) {
                    if (nbt != null) {
                        writer.println("MainInv:" + nbt.toString());
                        continue;
                    }
                    writer.println("NullInv");
                }
                for (NBTTagCompound c : snapshot.armorInventory) {
                    if (c != null) {
                        writer.println("ArmoInv:" + c.toString());
                        continue;
                    }
                    writer.println("NullArm");
                }
                if (snapshot.icon != null) {
                    NBTTagCompound icon = new NBTTagCompound();
                    snapshot.icon.func_77955_b(icon);
                    if (!icon.func_82582_d()) {
                        writer.println("IconSta:" + icon.toString());
                    }
                }
                if (snapshot.offHandInventory != null && !snapshot.offHandInventory.func_82582_d()) {
                    writer.println("OffHand:" + snapshot.offHandInventory.toString());
                }
                writer.println("END SAVE");
                continue;
            }
            writer.println("EMPTY SAVE");
        }
        writer.println("EOF");
        writer.close();
    }
}

