/*
 * Decompiled with CFR 0.152.
 */
package de.univrsal.justenoughbuttons.client.handlers;

import de.univrsal.justenoughbuttons.JEIButtons;
import de.univrsal.justenoughbuttons.client.ClientProxy;
import de.univrsal.justenoughbuttons.client.ClientUtil;
import de.univrsal.justenoughbuttons.client.EnumButtonCommands;
import de.univrsal.justenoughbuttons.client.Localization;
import de.univrsal.justenoughbuttons.client.MobOverlayRenderer;
import de.univrsal.justenoughbuttons.client.handlers.CommandHelper;
import de.univrsal.justenoughbuttons.client.handlers.InventorySaveHandler;
import de.univrsal.justenoughbuttons.client.handlers.ModSubsetButtonHandler;
import de.univrsal.justenoughbuttons.client.handlers.SaveFileHandler;
import de.univrsal.justenoughbuttons.core.CommonProxy;
import de.univrsal.justenoughbuttons.core.handlers.ConfigHandler;
import de.univrsal.justenoughbuttons.core.network.MessageNotifyClient;
import java.io.FileNotFoundException;
import java.io.UnsupportedEncodingException;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.MainMenuScreen;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.util.InputMappings;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.GameType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.client.config.GuiUtils;
import net.minecraftforge.fml.event.server.FMLServerStoppingEvent;
import net.minecraftforge.fml.loading.FMLEnvironment;

public class EventHandlers {
    private static BlockPos lastPlayerPos = null;
    private boolean drawMobOverlay = false;

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onDrawScreen(GuiScreenEvent.DrawScreenEvent e) {
        if (ConfigHandler.showButtons && e.getGui() != null && e.getGui() instanceof ContainerScreen) {
            List<String> tip;
            int mouseY = e.getMouseY();
            int mouseX = e.getMouseX();
            if (JEIButtons.isAnyButtonHovered && (tip = Localization.getTooltip(JEIButtons.hoveredButton)) != null) {
                GuiUtils.drawHoveringText(tip, (int)mouseX, (int)Math.max(mouseY, 17), (int)ClientUtil.getScreenWidth(), (int)ClientUtil.getScreenHeight(), (int)-1, (FontRenderer)ClientProxy.mc.field_71466_p);
                RenderHelper.func_74518_a();
            }
            if (ConfigHandler.enableSubsets) {
                ModSubsetButtonHandler.drawSubsetList(mouseX, mouseY);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onMousedown(GuiScreenEvent.MouseClickedEvent.Pre e) {
        int mouseY = ClientUtil.getMouseY();
        int mouseX = ClientUtil.getMouseX();
        if (e.getButton() == 0) {
            if (JEIButtons.isAnyButtonHovered && JEIButtons.hoveredButton.isEnabled) {
                CommandHelper.handleClick(JEIButtons.hoveredButton);
                ClientUtil.playClick();
            } else {
                if (ConfigHandler.enableSaves) {
                    InventorySaveHandler.click(mouseX, mouseY, e.getButton());
                }
                ModSubsetButtonHandler.click(mouseX, mouseY, e.getButton());
            }
        } else if (e.getButton() == 1) {
            InventorySaveHandler.click(mouseX, mouseY, e.getButton());
        }
        if (JEIButtons.isAnyButtonHovered) {
            e.setCanceled(true);
            e.setResult(Event.Result.DENY);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onDrawBackgroundEventPost(GuiScreenEvent.BackgroundDrawnEvent e) {
        if (JEIButtons.configHasChanged) {
            JEIButtons.configHasChanged = false;
            JEIButtons.setUpPositions();
        }
        if (JEIButtons.isServerSidePresent && e.getGui() instanceof MainMenuScreen) {
            JEIButtons.isServerSidePresent = false;
            JEIButtons.isSpongePresent = false;
        } else if (ConfigHandler.showButtons && e.getGui() != null && e.getGui() instanceof ContainerScreen) {
            int mouseY = ClientUtil.getMouseY();
            int mouseX = ClientUtil.getMouseX();
            ContainerScreen g = (ContainerScreen)e.getGui();
            PlayerEntity pl = ClientProxy.player;
            if (JEIButtons.btnGameMode == EnumButtonCommands.SPECTATE && !ConfigHandler.enableSpectatoreMode || JEIButtons.btnGameMode == EnumButtonCommands.ADVENTURE && !ConfigHandler.enableAdventureMode) {
                JEIButtons.btnGameMode = JEIButtons.btnGameMode.cycle();
            }
            JEIButtons.isAnyButtonHovered = false;
            JEIButtons.btnGameMode.draw();
            JEIButtons.btnTrash.draw();
            JEIButtons.btnSun.draw();
            JEIButtons.btnRain.draw();
            JEIButtons.btnDay.draw();
            JEIButtons.btnNight.draw();
            JEIButtons.btnNoMobs.draw();
            JEIButtons.btnFreeze.draw();
            JEIButtons.btnMagnet.draw();
            if (ConfigHandler.enableSaves) {
                InventorySaveHandler.drawButtons(mouseX, mouseY);
            }
            if (ModSubsetButtonHandler.ENABLE_SUBSETS && ConfigHandler.enableSubsets) {
                ModSubsetButtonHandler.drawButtons(mouseX, mouseY, ((ContainerScreen)e.getGui()).getGuiTop());
            }
            for (EnumButtonCommands btn : JEIButtons.btnCustom) {
                btn.draw();
            }
            this.adjustGamemode();
        }
    }

    private void adjustGamemode() {
        GameType t = ClientProxy.mc.field_71442_b.func_178889_l();
        boolean doSwitch = false;
        if (t == GameType.CREATIVE && JEIButtons.btnGameMode == EnumButtonCommands.CREATIVE) {
            doSwitch = true;
        } else if (t == GameType.SURVIVAL && JEIButtons.btnGameMode == EnumButtonCommands.SURVIVAL) {
            doSwitch = true;
        } else if (t == GameType.ADVENTURE && JEIButtons.btnGameMode == EnumButtonCommands.ADVENTURE) {
            doSwitch = true;
        } else if (t == GameType.SPECTATOR && JEIButtons.btnGameMode == EnumButtonCommands.SPECTATE) {
            doSwitch = true;
        }
        if (doSwitch) {
            JEIButtons.btnGameMode = JEIButtons.btnGameMode.cycle();
        }
    }

    @SubscribeEvent
    public void onWorldJoin(EntityJoinWorldEvent e) {
        if (FMLEnvironment.dist == Dist.CLIENT) {
            InventorySaveHandler.init();
            if (e.getEntity() instanceof PlayerEntity) {
                ClientProxy.player = Minecraft.func_71410_x().field_71439_g;
                JEIButtons.btnGameMode = ((PlayerEntity)e.getEntity()).func_184812_l_() ? JEIButtons.btnGameMode.cycle() : EnumButtonCommands.CREATIVE;
            }
        }
        if (e.getEntity() != null && e.getEntity() instanceof ServerPlayerEntity) {
            CommonProxy.network.sendToPlayer(new MessageNotifyClient(), (ServerPlayerEntity)e.getEntity());
        }
    }

    @SubscribeEvent
    public void onServerStopping(FMLServerStoppingEvent event) {
        if (SaveFileHandler.SAVE_SNAPSHOTS) {
            try {
                ClientProxy.saveHandler.saveForPlayer();
            }
            catch (FileNotFoundException | UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        JEIButtons.isServerSidePresent = false;
    }

    @SubscribeEvent
    public void handleKeyInputEvent(GuiScreenEvent.KeyboardKeyPressedEvent.Post e) {
        Screen gui = ClientProxy.mc.field_71462_r;
        if (gui instanceof ContainerScreen) {
            int keyCode = e.getKeyCode();
            if (ClientProxy.makeCopyKey.isActiveAndMatches(InputMappings.func_197954_a((int)e.getKeyCode(), (int)e.getScanCode()))) {
                Slot hovered = ((ContainerScreen)gui).getSlotUnderMouse();
                if (hovered != null && ClientProxy.player.field_71071_by.func_70445_o().func_190926_b() && !hovered.func_75211_c().func_190926_b() && hovered.func_75216_d()) {
                    ItemStack stack = hovered.func_75211_c().func_77946_l();
                    stack.func_190920_e(1);
                    CompoundNBT t = stack.func_77942_o() ? stack.func_77978_p() : new CompoundNBT();
                    t.func_74757_a("JEI_Ghost", true);
                    stack.func_77982_d(t);
                    ClientProxy.player.field_71071_by.func_70437_b(stack);
                }
            } else if (ClientProxy.hideAll.isActiveAndMatches(InputMappings.func_197954_a((int)e.getKeyCode(), (int)e.getScanCode()))) {
                ConfigHandler.showButtons = !ConfigHandler.showButtons;
            }
        }
    }

    @SubscribeEvent
    public void onMouseScrollEvent(GuiScreenEvent.MouseScrollEvent event) {
        if (event.getScrollDelta() != 0.0 && ModSubsetButtonHandler.isListShown) {
            ModSubsetButtonHandler.scroll(event.getScrollDelta());
        }
    }

    @SubscribeEvent
    public void onKeyPressed(InputEvent.KeyInputEvent event) {
        if (JEIButtons.enableOverlays) {
            if (ClientProxy.mobOverlay.func_151468_f()) {
                boolean bl = this.drawMobOverlay = !this.drawMobOverlay;
                if (!this.drawMobOverlay) {
                    MobOverlayRenderer.clearCache();
                    lastPlayerPos = null;
                }
            }
            if (ClientProxy.chunkOverlay.func_151468_f()) {
                ClientProxy.mc.field_184132_p.func_190075_b();
            }
        }
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (!(FMLEnvironment.dist != Dist.CLIENT || lastPlayerPos != null && lastPlayerPos.equals((Object)ClientProxy.player.func_180425_c()))) {
            if (this.drawMobOverlay) {
                MobOverlayRenderer.cacheMobSpawns((Entity)ClientProxy.player);
            }
            if (this.drawMobOverlay) {
                lastPlayerPos = ClientProxy.player.func_180425_c();
            }
        }
    }

    @SubscribeEvent
    public void onWorldDraw(RenderWorldLastEvent event) {
        if (this.drawMobOverlay) {
            MobOverlayRenderer.renderMobSpawnOverlay();
        }
        if (ClientProxy.mc.field_71462_r == null) {
            ModSubsetButtonHandler.isListShown = false;
            JEIButtons.isAnyButtonHovered = false;
        }
    }
}

